/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.transport;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.neuralsearch.stats.events.EventStatName;
import org.opensearch.neuralsearch.stats.events.TimestampedEventStatSnapshot;

public class NeuralStatsNodeResponse
extends BaseNodeResponse
implements ToXContentFragment {
    private Map<EventStatName, TimestampedEventStatSnapshot> stats;

    public NeuralStatsNodeResponse(StreamInput in) throws IOException {
        super(in);
        this.stats = in.readMap(input -> (EventStatName)input.readEnum(EventStatName.class), TimestampedEventStatSnapshot::new);
    }

    public NeuralStatsNodeResponse(DiscoveryNode node, Map<EventStatName, TimestampedEventStatSnapshot> stats) {
        super(node);
        this.stats = stats;
    }

    public static NeuralStatsNodeResponse readStats(StreamInput in) throws IOException {
        NeuralStatsNodeResponse neuralStats = new NeuralStatsNodeResponse(in);
        return neuralStats;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.stats, StreamOutput::writeEnum, (output, eventStatData) -> eventStatData.writeTo(output));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Map.Entry<EventStatName, TimestampedEventStatSnapshot> entry : this.stats.entrySet()) {
            EventStatName stat = entry.getKey();
            builder.field(stat.getFullPath(), entry.getValue().getValue());
        }
        return builder;
    }

    @Generated
    public Map<EventStatName, TimestampedEventStatSnapshot> getStats() {
        return this.stats;
    }
}

