/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.spark.SparkConf;
import org.apache.spark.api.python.Py4JServer;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.sys.package$;

public final class PythonGatewayServer$
implements Logging {
    public static final PythonGatewayServer$ MODULE$ = new PythonGatewayServer$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        MODULE$.initializeLogIfNecessary(true);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void main(String[] args) {
        SparkConf sparkConf = new SparkConf();
        Py4JServer gatewayServer = new Py4JServer(sparkConf);
        gatewayServer.start();
        int boundPort = gatewayServer.getListeningPort();
        if (boundPort == -1) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append(gatewayServer.server().getClass()).append(" failed to bind; exiting").toString());
            System.exit(1);
        } else {
            InetAddress address = InetAddress.getLoopbackAddress();
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Started PythonGatewayServer on ").append(address).append(" with port ").append(boundPort).toString());
        }
        File connectionInfoPath = new File((String)package$.MODULE$.env().apply((Object)"_PYSPARK_DRIVER_CONN_INFO_PATH"));
        File tmpPath = Files.createTempFile(connectionInfoPath.getParentFile().toPath(), "connection", ".info", new FileAttribute[0]).toFile();
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(tmpPath));
        dos.writeInt(boundPort);
        byte[] secretBytes = gatewayServer.secret().getBytes(StandardCharsets.UTF_8);
        dos.writeInt(secretBytes.length);
        dos.write(secretBytes, 0, secretBytes.length);
        dos.close();
        if (!tmpPath.renameTo(connectionInfoPath)) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Unable to write connection information to ").append(connectionInfoPath).append(".").toString());
            System.exit(1);
        }
        while (System.in.read() != -1) {
        }
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Exiting due to broken pipe from Python driver");
        System.exit(0);
    }

    private PythonGatewayServer$() {
    }
}

