/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.physical.node.join;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.opensearch.sql.legacy.query.planner.logical.node.Join;
import org.opensearch.sql.legacy.query.planner.physical.Row;
import org.opensearch.sql.legacy.query.planner.physical.node.join.DefaultHashTable;
import org.opensearch.sql.legacy.query.planner.physical.node.join.HashTable;
import org.opensearch.sql.legacy.query.planner.physical.node.join.ListHashTable;
import shaded.com.google.common.collect.Sets;

public class HashTableGroup<T>
implements HashTable<T> {
    private final HashTable<T>[] hashTables;
    private int numOfRows = 0;

    public HashTableGroup(Join.JoinCondition condition) {
        int groupSize = condition.groupSize();
        if (groupSize == 0) {
            this.hashTables = new HashTable[]{new ListHashTable()};
        } else {
            this.hashTables = new HashTable[groupSize];
            for (int i = 0; i < groupSize; ++i) {
                this.hashTables[i] = new DefaultHashTable(condition.leftColumnNames(i), condition.rightColumnNames(i));
            }
        }
    }

    @Override
    public void add(Row<T> row) {
        for (HashTable<T> hashTable : this.hashTables) {
            hashTable.add(row);
        }
        ++this.numOfRows;
    }

    @Override
    public Collection<Row<T>> match(Row<T> row) {
        Set allMatched = Sets.newIdentityHashSet();
        for (HashTable<T> hashTable : this.hashTables) {
            allMatched.addAll(hashTable.match(row));
        }
        return allMatched;
    }

    @Override
    public Map<String, Collection<Object>>[] rightFieldWithLeftValues() {
        return (Map[])Arrays.stream(this.hashTables).map(hashTable -> hashTable.rightFieldWithLeftValues()[0]).toArray(Map[]::new);
    }

    @Override
    public boolean isEmpty() {
        return this.numOfRows == 0;
    }

    @Override
    public int size() {
        return this.numOfRows;
    }

    @Override
    public void clear() {
        for (HashTable<T> hashTable : this.hashTables) {
            hashTable.clear();
        }
        this.numOfRows = 0;
    }
}

