/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.FamilyOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.opensearch.sql.data.type.ExprType;

public interface UDFOperandMetadata
extends SqlOperandMetadata {
    public SqlOperandTypeChecker getInnerTypeChecker();

    public static UDFOperandMetadata wrap(final FamilyOperandTypeChecker typeChecker) {
        return new UDFOperandMetadata(){

            @Override
            public SqlOperandTypeChecker getInnerTypeChecker() {
                return typeChecker;
            }

            public List<RelDataType> paramTypes(RelDataTypeFactory typeFactory) {
                return Collections.emptyList();
            }

            public List<String> paramNames() {
                return Collections.emptyList();
            }

            public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
                return typeChecker.checkOperandTypesWithoutTypeCoercion(callBinding, throwOnFailure);
            }

            public SqlOperandCountRange getOperandCountRange() {
                return typeChecker.getOperandCountRange();
            }

            public String getAllowedSignatures(SqlOperator op, String opName) {
                return typeChecker.getAllowedSignatures(op, opName);
            }
        };
    }

    public static UDFOperandMetadata wrap(final CompositeOperandTypeChecker typeChecker) {
        for (SqlOperandTypeChecker rule : typeChecker.getRules()) {
            if (rule instanceof FamilyOperandTypeChecker) continue;
            throw new IllegalArgumentException("Currently only compositions of ImplicitCastOperandTypeChecker are supported");
        }
        return new UDFOperandMetadata(){

            @Override
            public SqlOperandTypeChecker getInnerTypeChecker() {
                return typeChecker;
            }

            public List<RelDataType> paramTypes(RelDataTypeFactory typeFactory) {
                return Collections.emptyList();
            }

            public List<String> paramNames() {
                return Collections.emptyList();
            }

            public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
                return typeChecker.checkOperandTypes(callBinding, throwOnFailure);
            }

            public SqlOperandCountRange getOperandCountRange() {
                return typeChecker.getOperandCountRange();
            }

            public String getAllowedSignatures(SqlOperator op, String opName) {
                return typeChecker.getAllowedSignatures(op, opName);
            }
        };
    }

    public static UDFOperandMetadata wrapUDT(List<List<ExprType>> allowSignatures) {
        return new UDTOperandMetadata(allowSignatures);
    }

    public record UDTOperandMetadata(List<List<ExprType>> allowedParamTypes) implements UDFOperandMetadata
    {
        @Override
        public SqlOperandTypeChecker getInnerTypeChecker() {
            return this;
        }

        public List<RelDataType> paramTypes(RelDataTypeFactory typeFactory) {
            return List.of();
        }

        public List<String> paramNames() {
            return List.of();
        }

        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            return false;
        }

        public SqlOperandCountRange getOperandCountRange() {
            return null;
        }

        public String getAllowedSignatures(SqlOperator op, String opName) {
            return "";
        }
    }
}

