/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.aggregation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.aggregation.AggregationState;
import org.opensearch.sql.expression.aggregation.Aggregator;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.utils.ExpressionUtils;

public class VarianceAggregator
extends Aggregator<VarianceState> {
    private final boolean isSampleVariance;

    public static Aggregator variancePopulation(List<Expression> arguments, ExprCoreType returnType) {
        return new VarianceAggregator(false, arguments, returnType);
    }

    public static Aggregator varianceSample(List<Expression> arguments, ExprCoreType returnType) {
        return new VarianceAggregator(true, arguments, returnType);
    }

    public VarianceAggregator(Boolean isSampleVariance, List<Expression> arguments, ExprCoreType returnType) {
        super(isSampleVariance != false ? BuiltinFunctionName.VARSAMP.getName() : BuiltinFunctionName.VARPOP.getName(), arguments, returnType);
        this.isSampleVariance = isSampleVariance;
    }

    @Override
    public VarianceState create() {
        return new VarianceState(this.isSampleVariance);
    }

    @Override
    protected VarianceState iterate(ExprValue value, VarianceState state) {
        state.evaluate(value);
        return state;
    }

    public String toString() {
        return StringUtils.format("%s(%s)", this.isSampleVariance ? "var_samp" : "var_pop", ExpressionUtils.format(this.getArguments()));
    }

    protected static class VarianceState
    implements AggregationState {
        private final Variance variance;
        private final List<Double> values = new ArrayList<Double>();

        public VarianceState(boolean isSampleVariance) {
            this.variance = new Variance(isSampleVariance);
        }

        public void evaluate(ExprValue value) {
            this.values.add(value.doubleValue());
        }

        @Override
        public ExprValue result() {
            return this.values.size() == 0 ? ExprNullValue.of() : ExprValueUtils.doubleValue(this.variance.evaluate(this.values.stream().mapToDouble(d -> d).toArray()));
        }
    }
}

