/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.slice;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.opensearch.common.util.BitMixer;
import org.opensearch.search.slice.SliceQuery;

public final class DocValuesSliceQuery
extends SliceQuery {
    public DocValuesSliceQuery(String field, int id, int max) {
        super(field, id, max);
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, this, boost){
            final /* synthetic */ DocValuesSliceQuery this$0;
            {
                this.this$0 = this$0;
                super(query, score);
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.this$0.getField());
                DocIdSetIterator approximation = DocIdSetIterator.all((int)context.reader().maxDoc());
                TwoPhaseIterator twoPhase = new TwoPhaseIterator(this, approximation){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        super(approximation);
                    }

                    public boolean matches() throws IOException {
                        if (values.advanceExact(this.approximation.docID())) {
                            for (int i = 0; i < values.docValueCount(); ++i) {
                                if (!this.this$1.this$0.contains(BitMixer.mix((long)values.nextValue()))) continue;
                                return true;
                            }
                            return false;
                        }
                        return this.this$1.this$0.contains(0L);
                    }

                    public float matchCost() {
                        return 10.0f;
                    }
                };
                ConstantScoreScorer scorer = new ConstantScoreScorer(this.score(), scoreMode, twoPhase);
                return new Weight.DefaultScorerSupplier((Scorer)scorer);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{this.this$0.getField()});
            }
        };
    }
}

