/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.rest.action;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.jobscheduler.rest.action.VisibleForTesting;
import org.opensearch.jobscheduler.rest.request.GetJobDetailsRequest;
import org.opensearch.jobscheduler.utils.JobDetailsService;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.transport.client.node.NodeClient;

public class RestGetJobDetailsAction
extends BaseRestHandler {
    public static final String GET_JOB_DETAILS_ACTION = "get_job_details_action";
    private final Logger logger = LogManager.getLogger(RestGetJobDetailsAction.class);
    public JobDetailsService jobDetailsService;

    public RestGetJobDetailsAction(JobDetailsService jobDetailsService) {
        this.jobDetailsService = jobDetailsService;
    }

    public String getName() {
        return GET_JOB_DETAILS_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.ROOT, "%s/%s", "/_plugins/_job_scheduler", "_job_details")), new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.ROOT, "%s/%s/{%s}", "/_plugins/_job_scheduler", "_job_details", "document_id")));
    }

    @VisibleForTesting
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        XContentParser parser = restRequest.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        GetJobDetailsRequest getJobDetailsRequest = GetJobDetailsRequest.parse(parser);
        String documentId = restRequest.param("document_id");
        String jobIndex = getJobDetailsRequest.getJobIndex();
        String jobType = getJobDetailsRequest.getJobType();
        String jobParameterAction = getJobDetailsRequest.getJobParameterAction();
        String jobRunnerAction = getJobDetailsRequest.getJobRunnerAction();
        String extensionUniqueId = getJobDetailsRequest.getExtensionUniqueId();
        final CompletableFuture inProgressFuture = new CompletableFuture();
        this.jobDetailsService.processJobDetails(documentId, jobIndex, jobType, jobParameterAction, jobRunnerAction, extensionUniqueId, new ActionListener<String>(this){
            final /* synthetic */ RestGetJobDetailsAction this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(String indexedDocumentId) {
                inProgressFuture.complete(indexedDocumentId);
            }

            public void onFailure(Exception e) {
                this.this$0.logger.info("could not process job index", (Throwable)e);
                inProgressFuture.completeExceptionally(e);
            }
        });
        try {
            inProgressFuture.orTimeout(JobDetailsService.TIME_OUT_FOR_REQUEST, TimeUnit.SECONDS);
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof TimeoutException) {
                this.logger.error("Get Job Details timed out ", (Throwable)e);
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        return channel -> {
            BytesRestResponse bytesRestResponse;
            String jobDetailsResponseHolder = null;
            try {
                jobDetailsResponseHolder = (String)inProgressFuture.get();
            }
            catch (Exception e) {
                this.logger.error("Exception occured in get job details ", (Throwable)e);
            }
            XContentBuilder builder = channel.newBuilder();
            RestStatus restStatus = RestStatus.OK;
            String restResponseString = jobDetailsResponseHolder != null ? "success" : "failed";
            try {
                builder.startObject();
                builder.field("response", restResponseString);
                if (restResponseString.equals("success")) {
                    builder.field("document_id", jobDetailsResponseHolder);
                } else {
                    restStatus = RestStatus.INTERNAL_SERVER_ERROR;
                }
                builder.endObject();
                bytesRestResponse = new BytesRestResponse(restStatus, builder);
            }
            finally {
                builder.close();
            }
            channel.sendResponse((RestResponse)bytesRestResponse);
        };
    }
}

