/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.commons.alerting.model.DocLevelQuery;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestRequest;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.action.IndexDetectorAction;
import org.opensearch.securityanalytics.action.IndexDetectorRequest;
import org.opensearch.securityanalytics.action.SearchDetectorAction;
import org.opensearch.securityanalytics.action.SearchDetectorRequest;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.model.LogType;
import org.opensearch.securityanalytics.model.ThreatIntelFeedData;
import org.opensearch.securityanalytics.threatIntel.service.ThreatIntelFeedDataService;
import org.opensearch.securityanalytics.util.DetectorUtils;
import org.opensearch.transport.client.Client;

public class DetectorThreatIntelService {
    private static final Logger log = LogManager.getLogger(DetectorThreatIntelService.class);
    private final ThreatIntelFeedDataService threatIntelFeedDataService;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;

    public DetectorThreatIntelService(ThreatIntelFeedDataService threatIntelFeedDataService, Client client, NamedXContentRegistry xContentRegistry) {
        this.threatIntelFeedDataService = threatIntelFeedDataService;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    public List<DocLevelQuery> createDocLevelQueriesFromThreatIntelList(List<LogType.IocFields> iocFieldList, List<ThreatIntelFeedData> tifdList, Detector detector) {
        ArrayList<DocLevelQuery> queries = new ArrayList<DocLevelQuery>();
        Set<String> iocs = tifdList.stream().map(ThreatIntelFeedData::getIocValue).collect(Collectors.toSet());
        List logTypeIocs = iocFieldList.stream().map(LogType.IocFields::getIoc).collect(Collectors.toList());
        Map iocTypeToValues = tifdList.stream().filter(t -> logTypeIocs.contains(t.getIocType())).collect(Collectors.groupingBy(ThreatIntelFeedData::getIocType, Collectors.mapping(ThreatIntelFeedData::getIocValue, Collectors.toSet())));
        for (Map.Entry entry : iocTypeToValues.entrySet()) {
            String query = this.buildQueryStringQueryWithIocList(iocs);
            List<String> fields = iocFieldList.stream().filter(t -> ((String)entry.getKey()).matches(t.getIoc())).findFirst().get().getFields();
            for (String field : fields) {
                queries.add(new DocLevelQuery(DetectorThreatIntelService.constructId(detector, entry.getKey()), tifdList.get(0).getFeedId(), Collections.emptyList(), String.format(query, field), List.of("threat_intel", String.format("ioc_type:%s", entry.getKey()), String.format("field:%s", field), String.format("feed_name:%s", tifdList.get(0).getFeedId()))));
            }
        }
        return queries;
    }

    private String buildQueryStringQueryWithIocList(Set<String> iocs) {
        StringBuilder sb = new StringBuilder();
        sb.append("%s");
        sb.append(":");
        sb.append("(");
        for (String ioc : iocs) {
            if (sb.length() > 4) {
                sb.append(" OR ");
            }
            sb.append(ioc);
        }
        sb.append(")");
        return sb.toString();
    }

    public void createDocLevelQueryFromThreatIntel(List<LogType.IocFields> iocFieldList, Detector detector, ActionListener<List<DocLevelQuery>> listener) {
        try {
            if (!detector.getThreatIntelEnabled().booleanValue() || iocFieldList.isEmpty()) {
                listener.onResponse(Collections.emptyList());
                return;
            }
            this.threatIntelFeedDataService.getThreatIntelFeedData((ActionListener<List<ThreatIntelFeedData>>)ActionListener.wrap(threatIntelFeedData -> {
                if (threatIntelFeedData.isEmpty()) {
                    listener.onResponse(Collections.emptyList());
                } else {
                    listener.onResponse(this.createDocLevelQueriesFromThreatIntelList(iocFieldList, (List<ThreatIntelFeedData>)threatIntelFeedData, detector));
                }
            }, e -> {
                log.error("Failed to get threat intel feeds for doc level query creation", (Throwable)e);
                listener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            log.error("Failed to create doc level query from threat intel data", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    private static String constructId(Detector detector, String iocType) {
        return "threat_intel_" + String.valueOf(UUID.randomUUID());
    }

    public void updateDetectorsWithLatestThreatIntelRules() {
        NestedQueryBuilder queryBuilder = QueryBuilders.nestedQuery((String)"detector", (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"detector.threat_intel_enabled", (Object)true)), (ScoreMode)ScoreMode.Avg);
        SearchRequest searchRequest = new SearchRequest(new String[]{".opensearch-sap-detectors-config"});
        SearchSourceBuilder ssb = searchRequest.source();
        ssb.query((QueryBuilder)queryBuilder);
        ssb.size(9999);
        this.client.execute((ActionType)SearchDetectorAction.INSTANCE, (ActionRequest)new SearchDetectorRequest(searchRequest), ActionListener.wrap(searchResponse -> {
            List<Detector> detectors = DetectorUtils.getDetectors(searchResponse, this.xContentRegistry);
            detectors.forEach(detector -> {
                assert (detector.getThreatIntelEnabled().booleanValue());
                this.client.execute((ActionType)IndexDetectorAction.INSTANCE, (ActionRequest)new IndexDetectorRequest(detector.getId(), WriteRequest.RefreshPolicy.IMMEDIATE, RestRequest.Method.PUT, (Detector)detector), ActionListener.wrap(indexDetectorResponse -> log.debug("updated {} with latest threat intel info", (Object)indexDetectorResponse.getDetector().getId()), e -> log.error(() -> new ParameterizedMessage("Failed to update detector {} with latest threat intel info", (Object)detector.getId()), (Throwable)e)));
            });
        }, e -> log.error("Failed to fetch detectors to update with threat intel queries.", (Throwable)e)));
    }
}

