/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.model;

import java.io.IOException;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.securityanalytics.threatIntel.model.CustomSchemaIocUploadSource;
import org.opensearch.securityanalytics.threatIntel.model.IocUploadSource;
import org.opensearch.securityanalytics.threatIntel.model.S3Source;
import org.opensearch.securityanalytics.threatIntel.model.UrlDownloadSource;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;

public abstract class Source {
    private static final Logger log = LogManager.getLogger(Source.class);
    public static final String S3_FIELD = "s3";
    public static final String IOC_UPLOAD_FIELD = "ioc_upload";
    public static final String CUSTOM_SCHEMA_IOC_UPLOAD_FIELD = "custom_schema_ioc_upload";
    public static final String URL_DOWNLOAD_FIELD = "url_download";

    abstract String name();

    static Source readFrom(StreamInput sin) throws IOException {
        Type type = (Type)sin.readEnum(Type.class);
        switch (type.ordinal()) {
            case 0: {
                return new S3Source(sin);
            }
            case 1: {
                return new IocUploadSource(sin);
            }
            case 3: {
                return new CustomSchemaIocUploadSource(sin);
            }
            case 2: {
                return new UrlDownloadSource(sin);
            }
        }
        throw new IllegalStateException("Unexpected input [" + String.valueOf((Object)type) + "] when reading ioc store config");
    }

    public static Source parse(XContentParser xcp) throws IOException {
        Source source = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block12: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "s3": {
                    source = S3Source.parse(xcp);
                    continue block12;
                }
                case "ioc_upload": {
                    source = IocUploadSource.parse(xcp);
                    continue block12;
                }
                case "custom_schema_ioc_upload": {
                    source = CustomSchemaIocUploadSource.parse(xcp);
                    continue block12;
                }
                case "url_download": {
                    source = UrlDownloadSource.parse(xcp);
                    continue block12;
                }
            }
            throw new SecurityAnalyticsException("Unexpected input in 'source' field when reading ioc store config.", RestStatus.BAD_REQUEST, new IllegalArgumentException());
        }
        return source;
    }

    public void writeTo(StreamOutput out) throws IOException {
    }

    static enum Type {
        S3,
        IOC_UPLOAD,
        URL_DOWNLOAD,
        CUSTOM_SCHEMA_IOC_UPLOAD;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

