/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.rules.types;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.opensearch.securityanalytics.rules.types.SigmaBool;
import org.opensearch.securityanalytics.rules.types.SigmaNull;
import org.opensearch.securityanalytics.rules.types.SigmaNumber;
import org.opensearch.securityanalytics.rules.types.SigmaString;
import org.opensearch.securityanalytics.rules.types.SigmaType;

public class SigmaTypeFacade {
    private final Map<Class<?>, Class<? extends SigmaType>> typeMap = new HashMap();
    private static SigmaTypeFacade typeFacade;

    public SigmaTypeFacade() {
        this.typeMap.put(Boolean.TYPE, SigmaBool.class);
        this.typeMap.put(Integer.TYPE, SigmaNumber.class);
        this.typeMap.put(Float.TYPE, SigmaNumber.class);
        this.typeMap.put(String.class, SigmaString.class);
        this.typeMap.put(Optional.empty().getClass(), SigmaNull.class);
    }

    public static SigmaType sigmaType(Object val) {
        if (typeFacade == null) {
            typeFacade = new SigmaTypeFacade();
        }
        if (val == null) {
            return new SigmaNull();
        }
        if (val.getClass().equals(Boolean.class)) {
            return new SigmaBool((Boolean)val);
        }
        if (val.getClass().equals(Integer.class)) {
            return new SigmaNumber((Integer)val);
        }
        if (val.getClass().equals(Float.class)) {
            return new SigmaNumber(((Float)val).floatValue());
        }
        if (val.getClass().equals(String.class)) {
            return new SigmaString((String)val);
        }
        return new SigmaNull();
    }
}

