/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.resthandler;

import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.securityanalytics.action.IndexRuleAction;
import org.opensearch.securityanalytics.action.IndexRuleRequest;
import org.opensearch.securityanalytics.action.IndexRuleResponse;
import org.opensearch.transport.client.node.NodeClient;

public class RestIndexRuleAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestIndexRuleAction.class);

    public String getName() {
        return "index_rule_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_security_analytics/rules"), new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_security_analytics/rules/{ruleID}"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        log.debug(String.format(Locale.getDefault(), "%s %s", request.method(), "/_plugins/_security_analytics/rules"));
        WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.IMMEDIATE;
        if (request.hasParam("refresh")) {
            refreshPolicy = WriteRequest.RefreshPolicy.parse((String)request.param("refresh"));
        }
        String id = request.param("ruleID", "");
        String category = request.param("category");
        if (category == null) {
            throw new IllegalArgumentException("Missing category");
        }
        Boolean forced = request.paramAsBoolean("forced", false);
        String rule = request.content().utf8ToString();
        IndexRuleRequest ruleRequest = new IndexRuleRequest(id, refreshPolicy, category, request.method(), rule, forced);
        return channel -> client.execute((ActionType)IndexRuleAction.INSTANCE, (ActionRequest)ruleRequest, this.indexRuleResponse((RestChannel)channel, request.method()));
    }

    private RestResponseListener<IndexRuleResponse> indexRuleResponse(RestChannel channel, final RestRequest.Method restMethod) {
        return new RestResponseListener<IndexRuleResponse>(this, channel){

            public RestResponse buildResponse(IndexRuleResponse response) throws Exception {
                RestStatus returnStatus = RestStatus.CREATED;
                if (restMethod == RestRequest.Method.PUT) {
                    returnStatus = RestStatus.OK;
                }
                BytesRestResponse restResponse = new BytesRestResponse(returnStatus, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
                if (restMethod == RestRequest.Method.POST) {
                    String location = String.format(Locale.getDefault(), "%s/%s", "/_plugins/_security_analytics/rules", response.getId());
                    restResponse.addHeader("Location", location);
                }
                return restResponse;
            }
        };
    }
}

