/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.model;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.DataKey;
import com.amazonaws.encryptionsdk.internal.TrailingSignatureAlgorithm;
import com.amazonaws.encryptionsdk.model.DecryptionMaterials;
import java.security.PublicKey;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;

public class DecryptionMaterialsHandler {
    private DecryptionMaterials materials;
    private software.amazon.cryptography.materialproviders.model.DecryptionMaterials mplMaterials;

    public DecryptionMaterialsHandler(DecryptionMaterials materials) {
        this.materials = materials;
        this.mplMaterials = null;
    }

    public DecryptionMaterialsHandler(software.amazon.cryptography.materialproviders.model.DecryptionMaterials mplMaterials) {
        this.mplMaterials = mplMaterials;
        this.materials = null;
    }

    public DataKey<?> getDataKey() {
        if (this.materials != null) {
            return this.materials.getDataKey();
        }
        byte[] cacheDataKey = this.mplMaterials.plaintextDataKey().array();
        SecretKeySpec key = new SecretKeySpec(cacheDataKey, 0, cacheDataKey.length, CryptoAlgorithm.valueOf(this.mplMaterials.algorithmSuite().id().ESDK().name()).getDataKeyAlgo());
        return new DataKey<Object>(key, new byte[0], new byte[0], null);
    }

    public PublicKey getTrailingSignatureKey() {
        if (this.materials != null) {
            return this.materials.getTrailingSignatureKey();
        }
        if (this.mplMaterials.verificationKey() == null) {
            return null;
        }
        return TrailingSignatureAlgorithm.forCryptoAlgorithm(this.mplMaterials.algorithmSuite()).decompressPublicKey(this.mplMaterials.verificationKey().array());
    }

    public Map<String, String> getEncryptionContext() {
        if (this.materials != null) {
            return this.materials.getEncryptionContext();
        }
        return this.mplMaterials.encryptionContext();
    }

    public List<String> getRequiredEncryptionContextKeys() {
        if (this.materials != null) {
            return Collections.emptyList();
        }
        return this.mplMaterials.requiredEncryptionContextKeys();
    }
}

