/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.common;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.flowframework.exception.FlowFrameworkException;

public enum WorkflowResources {
    CREATE_CONNECTOR("create_connector", null, "delete_connector", "connector_id"),
    REGISTER_REMOTE_MODEL("register_remote_model", null, "delete_model", "model_id"),
    REGISTER_LOCAL_MODEL("register_local_custom_model", null, "delete_model", "model_id"),
    REGISTER_LOCAL_SPARSE_ENCODING_MODEL("register_local_sparse_encoding_model", null, "delete_model", "model_id"),
    REGISTER_LOCAL_PRETRAINED_MODEL("register_local_pretrained_model", null, "delete_model", "model_id"),
    REGISTER_MODEL_GROUP("register_model_group", null, "noop", "model_group_id"),
    DEPLOY_MODEL("deploy_model", null, "undeploy_model", "model_id"),
    CREATE_INGEST_PIPELINE("create_ingest_pipeline", "update_ingest_pipeline", "delete_ingest_pipeline", "pipeline_id"),
    CREATE_SEARCH_PIPELINE("create_search_pipeline", "update_search_pipeline", "delete_search_pipeline", "pipeline_id"),
    CREATE_INDEX("create_index", "update_index", "delete_index", "index_name"),
    REINDEX("reindex", null, "noop", "index_name"),
    REGISTER_AGENT("register_agent", null, "delete_agent", "agent_id");

    public static final String CONNECTOR_ID = "connector_id";
    public static final String MODEL_ID = "model_id";
    public static final String MODEL_GROUP_ID = "model_group_id";
    public static final String PIPELINE_ID = "pipeline_id";
    public static final String INDEX_NAME = "index_name";
    public static final String AGENT_ID = "agent_id";
    private final String createStep;
    private final String updateStep;
    private final String deprovisionStep;
    private final String resourceCreated;
    private static final Logger logger;
    private static final Set<String> allResources;

    private WorkflowResources(String createStep, String updateStep, String deprovisionStep, String resourceCreated) {
        this.createStep = createStep;
        this.updateStep = updateStep;
        this.deprovisionStep = deprovisionStep;
        this.resourceCreated = resourceCreated;
    }

    public String getCreateStep() {
        return this.createStep;
    }

    public String getUpdateStep() {
        return this.updateStep;
    }

    public String getDeprovisionStep() {
        return this.deprovisionStep;
    }

    public String getResourceCreated() {
        return this.resourceCreated;
    }

    public static String getResourceByWorkflowStep(String workflowStep) throws FlowFrameworkException {
        if (workflowStep != null && !workflowStep.isEmpty()) {
            for (WorkflowResources mapping : WorkflowResources.values()) {
                if (!workflowStep.equals(mapping.getCreateStep()) && !workflowStep.equals(mapping.getDeprovisionStep()) && !workflowStep.equals(mapping.getUpdateStep())) continue;
                return mapping.getResourceCreated();
            }
        }
        logger.error("Unable to find resource type for step: {}", (Object)workflowStep);
        throw new FlowFrameworkException("Unable to find resource type for step: " + workflowStep, RestStatus.BAD_REQUEST);
    }

    public static String getDeprovisionStepByWorkflowStep(String workflowStep) throws FlowFrameworkException {
        if (workflowStep != null && !workflowStep.isEmpty()) {
            for (WorkflowResources mapping : WorkflowResources.values()) {
                if (!mapping.getCreateStep().equals(workflowStep)) continue;
                return mapping.getDeprovisionStep();
            }
        }
        logger.error("Unable to find deprovision step for step: {}", (Object)workflowStep);
        throw new FlowFrameworkException("Unable to find deprovision step for step: " + workflowStep, RestStatus.BAD_REQUEST);
    }

    public static String getUpdateStepByWorkflowStep(String workflowStep) throws FlowFrameworkException {
        if (workflowStep != null && !workflowStep.isEmpty()) {
            for (WorkflowResources mapping : WorkflowResources.values()) {
                if (!mapping.getCreateStep().equals(workflowStep)) continue;
                return mapping.getUpdateStep();
            }
        }
        logger.error("Unable to find update step for step: {}", (Object)workflowStep);
        throw new FlowFrameworkException("Unable to find update step for step: " + workflowStep, RestStatus.BAD_REQUEST);
    }

    public static Set<String> getAllResourcesCreated() {
        return allResources;
    }

    static {
        logger = LogManager.getLogger(WorkflowResources.class);
        allResources = Stream.of(WorkflowResources.values()).map(WorkflowResources::getResourceCreated).collect(Collectors.toSet());
    }
}

