/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.indices.stats.IndexStats;
import org.opensearch.client.opensearch.indices.stats.IndexStatsBase;
import org.opensearch.client.opensearch.nodes.stats.NodeIndexShardStats;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NodeIndicesStats
extends IndexStatsBase
implements ToCopyableBuilder<Builder, NodeIndicesStats> {
    @Nonnull
    private final Map<String, IndexStats> indices;
    @Nonnull
    private final Map<String, List<NodeIndexShardStats>> shards;
    public static final JsonpDeserializer<NodeIndicesStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeIndicesStats::setupNodeIndicesStatsDeserializer);

    private NodeIndicesStats(Builder builder) {
        super(builder);
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.shards = ApiTypeHelper.unmodifiable(builder.shards);
    }

    public static NodeIndicesStats of(Function<Builder, ObjectBuilder<NodeIndicesStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, IndexStats> indices() {
        return this.indices;
    }

    @Nonnull
    public final Map<String, List<NodeIndexShardStats>> shards() {
        return this.shards;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartObject();
            for (Map.Entry<String, IndexStats> entry : this.indices.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.shards)) {
            generator.writeKey("shards");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.shards.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.writeStartArray();
                if (entry.getValue() != null) {
                    for (NodeIndexShardStats item1 : (List)entry.getValue()) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNodeIndicesStatsDeserializer(ObjectDeserializer<Builder> op) {
        NodeIndicesStats.setupIndexStatsBaseDeserializer(op);
        op.add(Builder::indices, JsonpDeserializer.stringMapDeserializer(IndexStats._DESERIALIZER), "indices");
        op.add(Builder::shards, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(NodeIndexShardStats._DESERIALIZER)), "shards");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.indices);
        result = 31 * result + Objects.hashCode(this.shards);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeIndicesStats other = (NodeIndicesStats)o;
        return Objects.equals(this.indices, other.indices) && Objects.equals(this.shards, other.shards);
    }

    public static class Builder
    extends IndexStatsBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, NodeIndicesStats> {
        @Nullable
        private Map<String, IndexStats> indices;
        @Nullable
        private Map<String, List<NodeIndexShardStats>> shards;

        public Builder() {
        }

        private Builder(NodeIndicesStats o) {
            super(o);
            this.indices = Builder._mapCopy(o.indices);
            this.shards = Builder._mapCopy(o.shards);
        }

        private Builder(Builder o) {
            super(o);
            this.indices = Builder._mapCopy(o.indices);
            this.shards = Builder._mapCopy(o.shards);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder indices(Map<String, IndexStats> map) {
            this.indices = Builder._mapPutAll(this.indices, map);
            return this;
        }

        @Nonnull
        public final Builder indices(String key, IndexStats value) {
            this.indices = Builder._mapPut(this.indices, key, value);
            return this;
        }

        @Nonnull
        public final Builder indices(String key, Function<IndexStats.Builder, ObjectBuilder<IndexStats>> fn) {
            return this.indices(key, fn.apply(new IndexStats.Builder()).build());
        }

        @Nonnull
        public final Builder shards(Map<String, List<NodeIndexShardStats>> map) {
            this.shards = Builder._mapPutAll(this.shards, map);
            return this;
        }

        @Nonnull
        public final Builder shards(String key, List<NodeIndexShardStats> value) {
            this.shards = Builder._mapPut(this.shards, key, value);
            return this;
        }

        @Override
        @Nonnull
        public NodeIndicesStats build() {
            this._checkSingleUse();
            return new NodeIndicesStats(this);
        }
    }
}

