/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.multipass;

import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.html.BasicRule;
import com.opensymphony.module.sitemesh.html.HTMLProcessor;
import com.opensymphony.module.sitemesh.html.Tag;
import com.opensymphony.module.sitemesh.html.util.CharArray;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;

public class MultipassReplacementPageParser
implements PageParser {
    private final Page page;
    private final HttpServletResponse response;

    public MultipassReplacementPageParser(Page page, HttpServletResponse response) {
        this.page = page;
        this.response = response;
    }

    public Page parse(char[] data) throws IOException {
        CharArray result = new CharArray(4096);
        HTMLProcessor processor = new HTMLProcessor(data, result);
        processor.addRule(new BasicRule("sitemesh:multipass"){

            public void process(Tag tag) {
                String id = tag.getAttributeValue("id", true);
                if (!MultipassReplacementPageParser.this.page.isPropertySet("_sitemesh.removefrompage." + id)) {
                    this.currentBuffer().append(MultipassReplacementPageParser.this.page.getProperty(id));
                }
            }
        });
        processor.process();
        result.writeTo(this.response.getWriter());
        return null;
    }
}

