/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.AbstractNetwork;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.MapIteratorCache;
import com.google.common.graph.MapRetrievalCache;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.NetworkConnections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

@ElementTypesAreNonnullByDefault
class StandardNetwork<N, E>
extends AbstractNetwork<N, E> {
    private final boolean isDirected;
    private final boolean allowsParallelEdges;
    private final boolean allowsSelfLoops;
    private final ElementOrder<N> nodeOrder;
    private final ElementOrder<E> edgeOrder;
    final MapIteratorCache<N, NetworkConnections<N, E>> nodeConnections;
    final MapIteratorCache<E, N> edgeToReferenceNode;

    StandardNetwork(NetworkBuilder<? super N, ? super E> builder2) {
        this(builder2, builder2.nodeOrder.createMap(builder2.expectedNodeCount.or(10)), builder2.edgeOrder.createMap(builder2.expectedEdgeCount.or(20)));
    }

    StandardNetwork(NetworkBuilder<? super N, ? super E> builder2, Map<N, NetworkConnections<N, E>> nodeConnections, Map<E, N> edgeToReferenceNode) {
        this.isDirected = builder2.directed;
        this.allowsParallelEdges = builder2.allowsParallelEdges;
        this.allowsSelfLoops = builder2.allowsSelfLoops;
        this.nodeOrder = builder2.nodeOrder.cast();
        this.edgeOrder = builder2.edgeOrder.cast();
        this.nodeConnections = nodeConnections instanceof TreeMap ? new MapRetrievalCache<N, NetworkConnections<N, E>>(nodeConnections) : new MapIteratorCache<N, NetworkConnections<N, E>>(nodeConnections);
        this.edgeToReferenceNode = new MapIteratorCache<E, N>(edgeToReferenceNode);
    }

    @Override
    public Set<N> nodes() {
        return this.nodeConnections.unmodifiableKeySet();
    }

    @Override
    public Set<E> edges() {
        return this.edgeToReferenceNode.unmodifiableKeySet();
    }

    @Override
    public boolean isDirected() {
        return this.isDirected;
    }

    @Override
    public boolean allowsParallelEdges() {
        return this.allowsParallelEdges;
    }

    @Override
    public boolean allowsSelfLoops() {
        return this.allowsSelfLoops;
    }

    @Override
    public ElementOrder<N> nodeOrder() {
        return this.nodeOrder;
    }

    @Override
    public ElementOrder<E> edgeOrder() {
        return this.edgeOrder;
    }

    @Override
    public Set<E> incidentEdges(N node2) {
        return this.nodeInvalidatableSet(this.checkedConnections(node2).incidentEdges(), node2);
    }

    @Override
    public EndpointPair<N> incidentNodes(E edge) {
        N nodeU = this.checkedReferenceNode(edge);
        N nodeV = Objects.requireNonNull(this.nodeConnections.get(nodeU)).adjacentNode(edge);
        return EndpointPair.of(this, nodeU, nodeV);
    }

    @Override
    public Set<N> adjacentNodes(N node2) {
        return this.nodeInvalidatableSet(this.checkedConnections(node2).adjacentNodes(), node2);
    }

    @Override
    public Set<E> edgesConnecting(N nodeU, N nodeV) {
        NetworkConnections<N, E> connectionsU = this.checkedConnections(nodeU);
        if (!this.allowsSelfLoops && nodeU == nodeV) {
            return ImmutableSet.of();
        }
        Preconditions.checkArgument(this.containsNode(nodeV), "Node %s is not an element of this graph.", nodeV);
        return this.nodePairInvalidatableSet(connectionsU.edgesConnecting(nodeV), nodeU, nodeV);
    }

    @Override
    public Set<E> inEdges(N node2) {
        return this.nodeInvalidatableSet(this.checkedConnections(node2).inEdges(), node2);
    }

    @Override
    public Set<E> outEdges(N node2) {
        return this.nodeInvalidatableSet(this.checkedConnections(node2).outEdges(), node2);
    }

    @Override
    public Set<N> predecessors(N node2) {
        return this.nodeInvalidatableSet(this.checkedConnections(node2).predecessors(), node2);
    }

    @Override
    public Set<N> successors(N node2) {
        return this.nodeInvalidatableSet(this.checkedConnections(node2).successors(), node2);
    }

    final NetworkConnections<N, E> checkedConnections(N node2) {
        NetworkConnections<N, E> connections = this.nodeConnections.get(node2);
        if (connections == null) {
            Preconditions.checkNotNull(node2);
            throw new IllegalArgumentException(String.format("Node %s is not an element of this graph.", node2));
        }
        return connections;
    }

    final N checkedReferenceNode(E edge) {
        N referenceNode = this.edgeToReferenceNode.get(edge);
        if (referenceNode == null) {
            Preconditions.checkNotNull(edge);
            throw new IllegalArgumentException(String.format("Edge %s is not an element of this graph.", edge));
        }
        return referenceNode;
    }

    final boolean containsNode(N node2) {
        return this.nodeConnections.containsKey(node2);
    }

    final boolean containsEdge(E edge) {
        return this.edgeToReferenceNode.containsKey(edge);
    }
}

