/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.baksmali.Adaptors;

import com.android.tools.smali.baksmali.Adaptors.EndTryLabelMethodItem;
import com.android.tools.smali.baksmali.Adaptors.LabelMethodItem;
import com.android.tools.smali.baksmali.Adaptors.MethodDefinition;
import com.android.tools.smali.baksmali.Adaptors.MethodItem;
import com.android.tools.smali.baksmali.BaksmaliOptions;
import com.android.tools.smali.baksmali.formatter.BaksmaliWriter;
import java.io.IOException;

public class CatchMethodItem
extends MethodItem {
    private final String exceptionType;
    private final LabelMethodItem tryStartLabel;
    private final LabelMethodItem tryEndLabel;
    private final LabelMethodItem handlerLabel;

    public CatchMethodItem(BaksmaliOptions options, MethodDefinition.LabelCache labelCache, int codeAddress, String exceptionType, int startAddress, int endAddress, int handlerAddress) {
        super(codeAddress);
        this.exceptionType = exceptionType;
        this.tryStartLabel = labelCache.internLabel(new LabelMethodItem(options, startAddress, "try_start_"));
        this.tryEndLabel = labelCache.internLabel(new EndTryLabelMethodItem(options, codeAddress, endAddress));
        this.handlerLabel = exceptionType == null ? labelCache.internLabel(new LabelMethodItem(options, handlerAddress, "catchall_")) : labelCache.internLabel(new LabelMethodItem(options, handlerAddress, "catch_"));
    }

    @Override
    public double getSortOrder() {
        return 102.0;
    }

    @Override
    public boolean writeTo(BaksmaliWriter writer) throws IOException {
        if (this.exceptionType == null) {
            writer.write(".catchall");
        } else {
            writer.write(".catch ");
            writer.write(this.exceptionType);
        }
        writer.write(" {");
        this.tryStartLabel.writeTo(writer);
        writer.write(" .. ");
        this.tryEndLabel.writeTo(writer);
        writer.write("} ");
        this.handlerLabel.writeTo(writer);
        return true;
    }
}

