/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jd.core.v1.model.javasyntax.declaration.ExpressionVariableInitializer;
import org.jd.core.v1.model.javasyntax.declaration.LocalVariableDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.LocalVariableDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.LocalVariableDeclarators;
import org.jd.core.v1.model.javasyntax.declaration.VariableInitializer;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.Expressions;
import org.jd.core.v1.model.javasyntax.expression.NewExpression;
import org.jd.core.v1.model.javasyntax.expression.NewInitializedArray;
import org.jd.core.v1.model.javasyntax.statement.ExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.LocalVariableDeclarationStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.DiamondTypeArgument;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgumentVisitor;
import org.jd.core.v1.model.javasyntax.type.TypeArguments;
import org.jd.core.v1.model.javasyntax.type.WildcardExtendsTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardSuperTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileConstructorInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileSuperConstructorInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileForStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.LocalVariableReference;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.ObjectLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.PrimitiveLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.LocalVariableMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchUndeclaredLocalVariableVisitor;
import org.jd.core.v1.util.DefaultList;

public class Frame {
    protected static final AbstractLocalVariableComparator ABSTRACT_LOCAL_VARIABLE_COMPARATOR = new AbstractLocalVariableComparator();
    protected static final HashSet<String> CAPITALIZED_JAVA_LANGUAGE_KEYWORDS = new HashSet<String>(Arrays.asList("Abstract", "Continue", "For", "New", "Switch", "Assert", "Default", "Goto", "Package", "Synchronized", "Boolean", "Do", "If", "Private", "This", "Break", "Double", "Implements", "Protected", "Throw", "Byte", "Else", "Import", "Public", "Throws", "Case", "Enum", "Instanceof", "Return", "Transient", "Catch", "Extends", "Int", "Short", "Try", "Char", "Final", "Interface", "Static", "Void", "Class", "Finally", "Long", "Strictfp", "Volatile", "Const", "Float", "Native", "Super", "While"));
    protected AbstractLocalVariable[] localVariableArray = new AbstractLocalVariable[10];
    protected HashMap<NewExpression, AbstractLocalVariable> newExpressions = null;
    protected DefaultList<Frame> children = null;
    protected Frame parent;
    protected Statements statements;
    protected AbstractLocalVariable exceptionLocalVariable = null;

    public Frame(Frame parent, Statements statements) {
        this.parent = parent;
        this.statements = statements;
    }

    public void addLocalVariable(AbstractLocalVariable lv) {
        AbstractLocalVariable next;
        assert (lv.getNext() == null) : "Frame.addLocalVariable(lv) : add local variable failed";
        int index = lv.getIndex();
        if (index >= this.localVariableArray.length) {
            AbstractLocalVariable[] tmp = this.localVariableArray;
            this.localVariableArray = new AbstractLocalVariable[index * 2];
            System.arraycopy(tmp, 0, this.localVariableArray, 0, tmp.length);
        }
        if ((next = this.localVariableArray[index]) != lv) {
            this.localVariableArray[index] = lv;
            lv.setNext(next);
            lv.setFrame(this);
        }
    }

    public AbstractLocalVariable getLocalVariable(int index) {
        AbstractLocalVariable lv;
        if (index < this.localVariableArray.length && (lv = this.localVariableArray[index]) != null) {
            return lv;
        }
        return this.parent.getLocalVariable(index);
    }

    public Frame getParent() {
        return this.parent;
    }

    public void setExceptionLocalVariable(AbstractLocalVariable exceptionLocalVariable) {
        this.exceptionLocalVariable = exceptionLocalVariable;
    }

    public void mergeLocalVariable(Map<String, BaseType> typeBounds, LocalVariableMaker localVariableMaker, AbstractLocalVariable lv) {
        int index = lv.getIndex();
        AbstractLocalVariable alvToMerge = index < this.localVariableArray.length ? this.localVariableArray[index] : null;
        if (alvToMerge != null) {
            if (!lv.isAssignableFrom(typeBounds, alvToMerge) && !alvToMerge.isAssignableFrom(typeBounds, lv)) {
                alvToMerge = null;
            } else if (lv.getName() != null && alvToMerge.getName() != null && !lv.getName().equals(alvToMerge.getName())) {
                alvToMerge = null;
            }
        }
        if (alvToMerge == null) {
            if (this.children != null) {
                for (Frame frame : this.children) {
                    frame.mergeLocalVariable(typeBounds, localVariableMaker, lv);
                }
            }
        } else if (lv != alvToMerge) {
            for (LocalVariableReference reference : alvToMerge.getReferences()) {
                reference.setLocalVariable(lv);
            }
            lv.getReferences().addAll(alvToMerge.getReferences());
            lv.setFromOffset(alvToMerge.getFromOffset());
            if (!lv.isAssignableFrom(typeBounds, alvToMerge) && !localVariableMaker.isCompatible(lv, alvToMerge.getType())) {
                Type type = lv.getType();
                Type alvToMergeType = alvToMerge.getType();
                assert (type.isPrimitive() == alvToMergeType.isPrimitive() && type.isObject() == alvToMergeType.isObject() && type.isGeneric() == alvToMergeType.isGeneric()) : "Frame.mergeLocalVariable(lv) : merge local variable failed";
                if (type.isPrimitive()) {
                    if (alvToMerge.isAssignableFrom(typeBounds, lv) || localVariableMaker.isCompatible(alvToMerge, lv.getType())) {
                        ((PrimitiveLocalVariable)lv).setType((PrimitiveType)alvToMergeType);
                    } else {
                        ((PrimitiveLocalVariable)lv).setType(PrimitiveType.TYPE_INT);
                    }
                } else if (type.isObject()) {
                    if (alvToMerge.isAssignableFrom(typeBounds, lv) || localVariableMaker.isCompatible(alvToMerge, lv.getType())) {
                        ((ObjectLocalVariable)lv).setType(typeBounds, alvToMergeType);
                    } else {
                        int dimension = Math.max(lv.getDimension(), alvToMerge.getDimension());
                        ((ObjectLocalVariable)lv).setType(typeBounds, ObjectType.TYPE_OBJECT.createType(dimension));
                    }
                }
            }
            this.localVariableArray[index] = alvToMerge.getNext();
        }
    }

    public void removeLocalVariable(AbstractLocalVariable lv) {
        int index = lv.getIndex();
        AbstractLocalVariable alvToRemove = index < this.localVariableArray.length && this.localVariableArray[index] == lv ? lv : null;
        if (alvToRemove == null) {
            if (this.children != null) {
                for (Frame frame : this.children) {
                    frame.removeLocalVariable(lv);
                }
            }
        } else {
            this.localVariableArray[index] = alvToRemove.getNext();
            alvToRemove.setNext(null);
        }
    }

    public void addChild(Frame child) {
        if (this.children == null) {
            this.children = new DefaultList();
        }
        this.children.add(child);
    }

    public void close() {
        if (this.newExpressions != null) {
            for (Map.Entry<NewExpression, AbstractLocalVariable> entry : this.newExpressions.entrySet()) {
                ObjectType ot1 = entry.getKey().getObjectType();
                ObjectType ot2 = (ObjectType)entry.getValue().getType();
                if (ot1.getTypeArguments() != null || ot2.getTypeArguments() == null) continue;
                entry.getKey().setObjectType(ot1.createType(ot2.getTypeArguments()));
            }
        }
    }

    public void createNames(HashSet<String> parentNames) {
        HashSet<String> names = new HashSet<String>(parentNames);
        HashMap<Type, Boolean> types = new HashMap<Type, Boolean>();
        int length = this.localVariableArray.length;
        for (int i = 0; i < length; ++i) {
            for (AbstractLocalVariable lv = this.localVariableArray[i]; lv != null; lv = lv.getNext()) {
                if (types.containsKey(lv.getType())) {
                    types.put(lv.getType(), Boolean.TRUE);
                } else {
                    types.put(lv.getType(), Boolean.FALSE);
                }
                if (lv.name != null) {
                    if (names.contains(lv.name)) {
                        lv.name = null;
                    } else {
                        names.add(lv.name);
                    }
                }
                assert (lv != lv.getNext());
            }
        }
        if (this.exceptionLocalVariable != null) {
            if (types.containsKey(this.exceptionLocalVariable.getType())) {
                types.put(this.exceptionLocalVariable.getType(), Boolean.TRUE);
            } else {
                types.put(this.exceptionLocalVariable.getType(), Boolean.FALSE);
            }
        }
        if (!types.isEmpty()) {
            GenerateLocalVariableNameVisitor visitor = new GenerateLocalVariableNameVisitor(names, types);
            for (int i = 0; i < length; ++i) {
                for (AbstractLocalVariable lv = this.localVariableArray[i]; lv != null; lv = lv.getNext()) {
                    if (lv.name != null) continue;
                    lv.getType().accept(visitor);
                    lv.name = visitor.getName();
                }
            }
            if (this.exceptionLocalVariable != null) {
                this.exceptionLocalVariable.getType().accept(visitor);
                this.exceptionLocalVariable.name = visitor.getName();
            }
        }
        if (this.children != null) {
            for (Frame child : this.children) {
                child.createNames(names);
            }
        }
    }

    public void createDeclarations() {
        boolean containsLineNumber = this.createInlineDeclarations();
        this.createStartBlockDeclarations();
        if (containsLineNumber) {
            this.mergeDeclarations();
        }
        if (this.children != null) {
            for (Frame child : this.children) {
                child.createDeclarations();
            }
        }
    }

    protected boolean createInlineDeclarations() {
        boolean containsLineNumber = false;
        HashMap<Frame, HashSet<AbstractLocalVariable>> map = this.createMapForInlineDeclarations();
        if (!map.isEmpty()) {
            SearchUndeclaredLocalVariableVisitor visitor = new SearchUndeclaredLocalVariableVisitor();
            block0: for (Map.Entry<Frame, HashSet<AbstractLocalVariable>> entry : map.entrySet()) {
                Statements statements = entry.getKey().statements;
                ListIterator<Statement> iterator = statements.listIterator();
                HashSet<AbstractLocalVariable> undeclaredLocalVariables = entry.getValue();
                while (iterator.hasNext()) {
                    Statement statement = (Statement)iterator.next();
                    visitor.init();
                    statement.accept(visitor);
                    containsLineNumber |= visitor.containsLineNumber();
                    HashSet<AbstractLocalVariable> undeclaredLocalVariablesInStatement = visitor.getVariables();
                    undeclaredLocalVariablesInStatement.retainAll(undeclaredLocalVariables);
                    if (!undeclaredLocalVariablesInStatement.isEmpty()) {
                        int index1 = iterator.nextIndex();
                        Class<?> statementClass = statement.getClass();
                        if (statementClass == ExpressionStatement.class) {
                            this.createInlineDeclarations(undeclaredLocalVariables, undeclaredLocalVariablesInStatement, iterator, (ExpressionStatement)statement);
                        } else if (statementClass == ClassFileForStatement.class) {
                            this.createInlineDeclarations(undeclaredLocalVariables, undeclaredLocalVariablesInStatement, (ClassFileForStatement)statement);
                        }
                        if (!undeclaredLocalVariablesInStatement.isEmpty()) {
                            int index2 = iterator.nextIndex() + undeclaredLocalVariablesInStatement.size();
                            while (iterator.nextIndex() >= index1) {
                                iterator.previous();
                            }
                            DefaultList<AbstractLocalVariable> sorted = new DefaultList<AbstractLocalVariable>((Collection<AbstractLocalVariable>)undeclaredLocalVariablesInStatement);
                            sorted.sort(ABSTRACT_LOCAL_VARIABLE_COMPARATOR);
                            for (AbstractLocalVariable lv : sorted) {
                                iterator.add(new LocalVariableDeclarationStatement(lv.getType(), new LocalVariableDeclarator(lv.getName())));
                                lv.setDeclared(true);
                                undeclaredLocalVariables.remove(lv);
                            }
                            while (iterator.nextIndex() < index2) {
                                iterator.next();
                            }
                        }
                    }
                    if (!undeclaredLocalVariables.isEmpty()) continue;
                    continue block0;
                }
            }
        }
        return containsLineNumber;
    }

    protected HashMap<Frame, HashSet<AbstractLocalVariable>> createMapForInlineDeclarations() {
        HashMap<Frame, HashSet<AbstractLocalVariable>> map = new HashMap<Frame, HashSet<AbstractLocalVariable>>();
        int i = this.localVariableArray.length;
        while (i-- > 0) {
            for (AbstractLocalVariable lv = this.localVariableArray[i]; lv != null; lv = lv.getNext()) {
                if (this != lv.getFrame() || lv.isDeclared()) continue;
                HashSet<AbstractLocalVariable> variablesToDeclare = map.get(lv.getFrame());
                if (variablesToDeclare == null) {
                    variablesToDeclare = new HashSet();
                    variablesToDeclare.add(lv);
                    map.put(lv.getFrame(), variablesToDeclare);
                    continue;
                }
                variablesToDeclare.add(lv);
            }
        }
        return map;
    }

    protected void createInlineDeclarations(HashSet<AbstractLocalVariable> undeclaredLocalVariables, HashSet<AbstractLocalVariable> undeclaredLocalVariablesInStatement, ListIterator<Statement> iterator, ExpressionStatement es) {
        BinaryOperatorExpression boe;
        if (es.getExpression().getClass() == BinaryOperatorExpression.class && (boe = (BinaryOperatorExpression)es.getExpression()).getOperator().equals("=")) {
            Expressions expressions = new Expressions();
            this.splitMultiAssignment(Integer.MAX_VALUE, undeclaredLocalVariablesInStatement, expressions, boe);
            iterator.remove();
            for (Expression exp : expressions) {
                iterator.add(this.newDeclarationStatement(undeclaredLocalVariables, undeclaredLocalVariablesInStatement, (BinaryOperatorExpression)exp));
            }
            if (expressions.isEmpty()) {
                iterator.add(es);
            }
        }
    }

    protected Expression splitMultiAssignment(int toOffset, HashSet<AbstractLocalVariable> undeclaredLocalVariablesInStatement, List<Expression> expressions, Expression expression) {
        BinaryOperatorExpression boe;
        if (expression.getClass() == BinaryOperatorExpression.class && (boe = (BinaryOperatorExpression)expression).getOperator().equals("=")) {
            ClassFileLocalVariableReferenceExpression lvre;
            AbstractLocalVariable localVariable;
            Expression rightExpression = this.splitMultiAssignment(toOffset, undeclaredLocalVariablesInStatement, expressions, boe.getRightExpression());
            if (boe.getLeftExpression().getClass() == ClassFileLocalVariableReferenceExpression.class && undeclaredLocalVariablesInStatement.contains(localVariable = (lvre = (ClassFileLocalVariableReferenceExpression)boe.getLeftExpression()).getLocalVariable()) && localVariable.getToOffset() <= toOffset) {
                if (rightExpression == boe.getRightExpression()) {
                    expressions.add(boe);
                } else {
                    expressions.add(new BinaryOperatorExpression(boe.getLineNumber(), boe.getType(), lvre, "=", rightExpression, boe.getPriority()));
                }
                return lvre;
            }
        }
        return expression;
    }

    protected LocalVariableDeclarationStatement newDeclarationStatement(HashSet<AbstractLocalVariable> undeclaredLocalVariables, HashSet<AbstractLocalVariable> undeclaredLocalVariablesInStatement, BinaryOperatorExpression boe) {
        ClassFileLocalVariableReferenceExpression reference = (ClassFileLocalVariableReferenceExpression)boe.getLeftExpression();
        AbstractLocalVariable localVariable = reference.getLocalVariable();
        undeclaredLocalVariables.remove(localVariable);
        undeclaredLocalVariablesInStatement.remove(localVariable);
        localVariable.setDeclared(true);
        Type type = localVariable.getType();
        VariableInitializer variableInitializer = boe.getRightExpression().getClass() == NewInitializedArray.class ? (type.isObject() && ((ObjectType)type).getTypeArguments() != null ? new ExpressionVariableInitializer(boe.getRightExpression()) : ((NewInitializedArray)boe.getRightExpression()).getArrayInitializer()) : new ExpressionVariableInitializer(boe.getRightExpression());
        return new LocalVariableDeclarationStatement(type, new LocalVariableDeclarator(boe.getLineNumber(), reference.getName(), variableInitializer));
    }

    protected void createInlineDeclarations(HashSet<AbstractLocalVariable> undeclaredLocalVariables, HashSet<AbstractLocalVariable> undeclaredLocalVariablesInStatement, ClassFileForStatement fs) {
        BaseExpression init = fs.getInit();
        if (init != null) {
            Expressions expressions = new Expressions();
            int toOffset = fs.getToOffset();
            if (init.isList()) {
                for (Expression exp : init) {
                    this.splitMultiAssignment(toOffset, undeclaredLocalVariablesInStatement, expressions, exp);
                    if (!expressions.isEmpty()) continue;
                    expressions.add(exp);
                }
            } else {
                this.splitMultiAssignment(toOffset, undeclaredLocalVariablesInStatement, expressions, (Expression)init.getFirst());
                if (expressions.isEmpty()) {
                    expressions.add(init.getFirst());
                }
            }
            if (expressions.size() == 1) {
                this.updateForStatement(undeclaredLocalVariables, undeclaredLocalVariablesInStatement, fs, (Expression)expressions.getFirst());
            } else {
                this.updateForStatement(undeclaredLocalVariables, undeclaredLocalVariablesInStatement, fs, expressions);
            }
        }
    }

    protected void updateForStatement(HashSet<AbstractLocalVariable> undeclaredLocalVariables, HashSet<AbstractLocalVariable> undeclaredLocalVariablesInStatement, ClassFileForStatement forStatement, Expression init) {
        if (init.getClass() != BinaryOperatorExpression.class) {
            return;
        }
        BinaryOperatorExpression boe = (BinaryOperatorExpression)init;
        if (boe.getLeftExpression().getClass() != ClassFileLocalVariableReferenceExpression.class) {
            return;
        }
        ClassFileLocalVariableReferenceExpression reference = (ClassFileLocalVariableReferenceExpression)boe.getLeftExpression();
        AbstractLocalVariable localVariable = reference.getLocalVariable();
        if (localVariable.isDeclared() || localVariable.getToOffset() > forStatement.getToOffset()) {
            return;
        }
        undeclaredLocalVariables.remove(localVariable);
        undeclaredLocalVariablesInStatement.remove(localVariable);
        localVariable.setDeclared(true);
        VariableInitializer variableInitializer = boe.getRightExpression().getClass() == NewInitializedArray.class ? ((NewInitializedArray)boe.getRightExpression()).getArrayInitializer() : new ExpressionVariableInitializer(boe.getRightExpression());
        forStatement.setDeclaration(new LocalVariableDeclaration(localVariable.getType(), new LocalVariableDeclarator(boe.getLineNumber(), reference.getName(), variableInitializer)));
        forStatement.setInit(null);
    }

    protected void updateForStatement(HashSet<AbstractLocalVariable> variablesToDeclare, HashSet<AbstractLocalVariable> foundVariables, ClassFileForStatement forStatement, Expressions init) {
        DefaultList<BinaryOperatorExpression> boes = new DefaultList<BinaryOperatorExpression>();
        DefaultList<AbstractLocalVariable> localVariables = new DefaultList<AbstractLocalVariable>();
        Type type0 = null;
        Type type1 = null;
        int minDimension = 0;
        int maxDimension = 0;
        for (Expression expression : init) {
            if (expression.getClass() != BinaryOperatorExpression.class) {
                return;
            }
            BinaryOperatorExpression boe = (BinaryOperatorExpression)expression;
            if (boe.getLeftExpression().getClass() != ClassFileLocalVariableReferenceExpression.class) {
                return;
            }
            AbstractLocalVariable localVariable = ((ClassFileLocalVariableReferenceExpression)boe.getLeftExpression()).getLocalVariable();
            if (localVariable.isDeclared() || localVariable.getToOffset() > forStatement.getToOffset()) {
                return;
            }
            if (type1 == null) {
                type1 = localVariable.getType();
                type0 = type1.createType(0);
                minDimension = maxDimension = type1.getDimension();
            } else {
                Type type2 = localVariable.getType();
                if (!type1.equals(type2) && !type0.equals(type2.createType(0))) {
                    return;
                }
                int dimension = type2.getDimension();
                if (minDimension > dimension) {
                    minDimension = dimension;
                }
                if (maxDimension < dimension) {
                    maxDimension = dimension;
                }
            }
            localVariables.add(localVariable);
            boes.add(boe);
        }
        for (AbstractLocalVariable lv : localVariables) {
            variablesToDeclare.remove(lv);
            foundVariables.remove(lv);
            lv.setDeclared(true);
        }
        if (minDimension == maxDimension) {
            forStatement.setDeclaration(new LocalVariableDeclaration(type1, this.createDeclarators1(boes, false)));
        } else {
            forStatement.setDeclaration(new LocalVariableDeclaration(type0, this.createDeclarators1(boes, true)));
        }
        forStatement.setInit(null);
    }

    protected LocalVariableDeclarators createDeclarators1(DefaultList<BinaryOperatorExpression> boes, boolean setDimension) {
        LocalVariableDeclarators declarators = new LocalVariableDeclarators(boes.size());
        for (BinaryOperatorExpression boe : boes) {
            ClassFileLocalVariableReferenceExpression reference = (ClassFileLocalVariableReferenceExpression)boe.getLeftExpression();
            VariableInitializer variableInitializer = boe.getRightExpression().getClass() == NewInitializedArray.class ? ((NewInitializedArray)boe.getRightExpression()).getArrayInitializer() : new ExpressionVariableInitializer(boe.getRightExpression());
            LocalVariableDeclarator declarator = new LocalVariableDeclarator(boe.getLineNumber(), reference.getName(), variableInitializer);
            if (setDimension) {
                declarator.setDimension(reference.getLocalVariable().getDimension());
            }
            declarators.add(declarator);
        }
        return declarators;
    }

    protected void createStartBlockDeclarations() {
        int addIndex = -1;
        int i = this.localVariableArray.length;
        while (i-- > 0) {
            for (AbstractLocalVariable lv = this.localVariableArray[i]; lv != null; lv = lv.getNext()) {
                if (lv.isDeclared()) continue;
                if (addIndex == -1) {
                    addIndex = this.getAddIndex();
                }
                this.statements.add(addIndex, new LocalVariableDeclarationStatement(lv.getType(), new LocalVariableDeclarator(lv.getName())));
                lv.setDeclared(true);
            }
        }
    }

    protected int getAddIndex() {
        int addIndex = 0;
        if (this.parent.parent == null) {
            Class<?> expressionClass;
            Statement statement;
            int len = this.statements.size();
            while (addIndex < len && ((statement = (Statement)this.statements.get(addIndex++)).getClass() != ExpressionStatement.class || (expressionClass = ((ExpressionStatement)statement).getExpression().getClass()) != ClassFileSuperConstructorInvocationExpression.class && expressionClass != ClassFileConstructorInvocationExpression.class)) {
            }
            if (addIndex >= len) {
                addIndex = 0;
            }
        }
        return addIndex;
    }

    protected void mergeDeclarations() {
        int size = this.statements.size();
        if (size > 1) {
            DefaultList<LocalVariableDeclarationStatement> declarations = new DefaultList<LocalVariableDeclarationStatement>();
            ListIterator<LocalVariableDeclarationStatement> iterator = this.statements.listIterator();
            while (iterator.hasNext()) {
                int declarationSize;
                int minDimension;
                Statement previous;
                while ((previous = (Statement)iterator.next()).getClass() != LocalVariableDeclarationStatement.class && iterator.hasNext()) {
                }
                if (previous.getClass() != LocalVariableDeclarationStatement.class) continue;
                LocalVariableDeclarationStatement lvds1 = (LocalVariableDeclarationStatement)previous;
                Type type1 = lvds1.getType();
                Type type0 = type1.createType(0);
                int maxDimension = minDimension = type1.getDimension();
                int lineNumber1 = lvds1.getLocalVariableDeclarators().getLineNumber();
                declarations.clear();
                declarations.add(lvds1);
                while (iterator.hasNext()) {
                    Statement statement = (Statement)iterator.next();
                    if (statement.getClass() != LocalVariableDeclarationStatement.class) {
                        iterator.previous();
                        break;
                    }
                    LocalVariableDeclarationStatement lvds2 = (LocalVariableDeclarationStatement)statement;
                    int lineNumber2 = lvds2.getLocalVariableDeclarators().getLineNumber();
                    if (lineNumber1 != lineNumber2 && lineNumber1 > 0) {
                        iterator.previous();
                        break;
                    }
                    lineNumber1 = lineNumber2;
                    Type type2 = lvds2.getType();
                    int dimension = type2.getDimension();
                    if (type1.equals(type2)) {
                        declarations.add(lvds2);
                        continue;
                    }
                    if (type0.equals(type2.createType(0))) {
                        if (minDimension > dimension) {
                            minDimension = dimension;
                        }
                        if (maxDimension < dimension) {
                            maxDimension = dimension;
                        }
                        declarations.add(lvds2);
                        continue;
                    }
                    iterator.previous();
                    break;
                }
                if ((declarationSize = declarations.size()) <= 1) continue;
                while (--declarationSize > 0) {
                    iterator.previous();
                    iterator.remove();
                }
                iterator.previous();
                if (minDimension == maxDimension) {
                    iterator.set(new LocalVariableDeclarationStatement(type1, this.createDeclarators2(declarations, false)));
                } else {
                    iterator.set(new LocalVariableDeclarationStatement(type0, this.createDeclarators2(declarations, true)));
                }
                iterator.next();
            }
        }
    }

    protected LocalVariableDeclarators createDeclarators2(DefaultList<LocalVariableDeclarationStatement> declarations, boolean setDimension) {
        LocalVariableDeclarators declarators = new LocalVariableDeclarators(declarations.size());
        for (LocalVariableDeclarationStatement declaration : declarations) {
            LocalVariableDeclarator declarator = (LocalVariableDeclarator)declaration.getLocalVariableDeclarators();
            if (setDimension) {
                declarator.setDimension(declaration.getType().getDimension());
            }
            declarators.add(declarator);
        }
        return declarators;
    }

    protected static class AbstractLocalVariableComparator
    implements Comparator<AbstractLocalVariable> {
        protected AbstractLocalVariableComparator() {
        }

        @Override
        public int compare(AbstractLocalVariable alv1, AbstractLocalVariable alv2) {
            return alv1.getIndex() - alv2.getIndex();
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }
    }

    protected static class GenerateLocalVariableNameVisitor
    implements TypeArgumentVisitor {
        protected static final String[] INTEGER_NAMES = new String[]{"i", "j", "k", "m", "n"};
        protected StringBuilder sb = new StringBuilder();
        protected HashSet<String> blackListNames;
        protected HashMap<Type, Boolean> types;
        protected String name;

        public GenerateLocalVariableNameVisitor(HashSet<String> blackListNames, HashMap<Type, Boolean> types) {
            this.blackListNames = blackListNames;
            this.types = types;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public void visit(PrimitiveType type) {
            this.sb.setLength(0);
            switch (type.getJavaPrimitiveFlags()) {
                case 16: {
                    this.sb.append("b");
                    break;
                }
                case 2: {
                    this.sb.append("c");
                    break;
                }
                case 8: {
                    this.sb.append("d");
                    break;
                }
                case 4: {
                    this.sb.append("f");
                    break;
                }
                case 64: {
                    for (String in : INTEGER_NAMES) {
                        if (this.blackListNames.contains(in)) continue;
                        this.name = in;
                        this.blackListNames.add(this.name);
                        return;
                    }
                    this.sb.append("i");
                    break;
                }
                case 128: {
                    this.sb.append("l");
                    break;
                }
                case 32: {
                    this.sb.append("s");
                    break;
                }
                case 1: {
                    this.sb.append("bool");
                }
            }
            this.generate(type);
        }

        @Override
        public void visit(ObjectType type) {
            this.visit(type, type.getName());
        }

        @Override
        public void visit(InnerObjectType type) {
            this.visit(type, type.getName());
        }

        @Override
        public void visit(GenericType type) {
            this.visit(type, type.getName());
        }

        protected void visit(Type type, String str) {
            this.sb.setLength(0);
            switch (type.getDimension()) {
                case 0: {
                    if ("Class".equals(str)) {
                        this.sb.append("clazz");
                        break;
                    }
                    if ("String".equals(str)) {
                        this.sb.append("str");
                        break;
                    }
                    if ("Boolean".equals(str)) {
                        this.sb.append("bool");
                        break;
                    }
                    this.uncapitalize(str);
                    if (!CAPITALIZED_JAVA_LANGUAGE_KEYWORDS.contains(str)) break;
                    this.sb.append("_");
                    break;
                }
                default: {
                    this.sb.append("arrayOf");
                    this.capitalize(str);
                }
            }
            this.generate(type);
        }

        protected void capitalize(String str) {
            int length;
            if (str != null && (length = str.length()) > 0) {
                char firstChar = str.charAt(0);
                if (Character.isUpperCase(firstChar)) {
                    this.sb.append(str);
                } else {
                    this.sb.append(Character.toUpperCase(firstChar));
                    if (length > 1) {
                        this.sb.append(str.substring(1));
                    }
                }
            }
        }

        protected void uncapitalize(String str) {
            int length;
            if (str != null && (length = str.length()) > 0) {
                char firstChar = str.charAt(0);
                if (Character.isLowerCase(firstChar)) {
                    this.sb.append(str);
                } else {
                    this.sb.append(Character.toLowerCase(firstChar));
                    if (length > 1) {
                        this.sb.append(str.substring(1));
                    }
                }
            }
        }

        protected void generate(Type type) {
            int length = this.sb.length();
            int counter = 1;
            if (this.types.get(type).booleanValue()) {
                this.sb.append(counter++);
            }
            this.name = this.sb.toString();
            while (this.blackListNames.contains(this.name)) {
                this.sb.setLength(length);
                this.sb.append(counter++);
                this.name = this.sb.toString();
            }
            this.blackListNames.add(this.name);
        }

        @Override
        public void visit(TypeArguments type) {
        }

        @Override
        public void visit(DiamondTypeArgument type) {
        }

        @Override
        public void visit(WildcardExtendsTypeArgument type) {
        }

        @Override
        public void visit(WildcardSuperTypeArgument type) {
        }

        @Override
        public void visit(WildcardTypeArgument type) {
        }
    }
}

