/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql.jdbcwrapper;

import ca.sqlpower.util.Cache;
import ca.sqlpower.util.CacheStats;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ReferenceMap;

class MetaDataCache<K, V>
implements Cache<K, V> {
    private final Map<K, V> data = new ReferenceMap(0, 1);
    private long lastFlushDate;
    private final MyCacheStats stats = new MyCacheStats();

    @Override
    public void flush() {
        this.clear();
    }

    @Override
    public Date getLastFlushDate() {
        return new Date(this.lastFlushDate);
    }

    @Override
    public int getMaxMembers() {
        return Integer.MAX_VALUE;
    }

    @Override
    public CacheStats getStats() {
        return this.stats;
    }

    @Override
    public void setMaxMembers(int argMaxMembers) {
        throw new UnsupportedOperationException("This cache uses weak references, and doesn't limit max members");
    }

    @Override
    public void clear() {
        this.data.clear();
        this.stats.cacheFlush();
        this.lastFlushDate = System.currentTimeMillis();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.data.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.data.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.data).equals(o);
    }

    @Override
    public V get(Object key) {
        V v = this.data.get(key);
        if (v == null) {
            this.stats.incrementMisses();
        } else {
            this.stats.incrementHits();
        }
        return v;
    }

    @Override
    public int hashCode() {
        return ((Object)this.data).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.data.keySet();
    }

    @Override
    public V put(K key, V value) {
        this.stats.incrementInserts(1);
        return this.data.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        this.stats.incrementInserts(t.size());
        this.data.putAll(t);
    }

    @Override
    public V remove(Object key) {
        return this.data.remove(key);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Collection<V> values() {
        return this.data.values();
    }

    private class MyCacheStats
    extends CacheStats {
        private MyCacheStats() {
        }

        public void incrementHits() {
            ++this.totalRequested;
            ++this.totalHits;
        }

        public void incrementMisses() {
            ++this.totalRequested;
            ++this.totalMisses;
        }

        public void incrementInserts(int number) {
            this.totalInserted += number;
        }
    }
}

