/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import org.apache.xerces.utils.HexBin;
import org.apache.xerces.validators.datatype.AbstractStringValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class HexBinaryDatatypeValidator
extends AbstractStringValidator {
    public HexBinaryDatatypeValidator() throws InvalidDatatypeFacetException {
        super(null, null, false);
    }

    public HexBinaryDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        super(datatypeValidator, hashtable, bl);
    }

    protected void assignAdditionalFacets(String string, Hashtable hashtable) throws InvalidDatatypeFacetException {
        throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_STRING_FACET, 0, new Object[]{string}));
    }

    protected void checkValueSpace(String string) throws InvalidDatatypeValueException {
        if (this.getLength(string) < 0) {
            throw new InvalidDatatypeValueException("Value '" + string + "' is not encoded in Hex");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        HexBinaryDatatypeValidator hexBinaryDatatypeValidator = null;
        try {
            hexBinaryDatatypeValidator = new HexBinaryDatatypeValidator();
            hexBinaryDatatypeValidator.fLocale = this.fLocale;
            hexBinaryDatatypeValidator.fBaseValidator = this.fBaseValidator;
            hexBinaryDatatypeValidator.fLength = this.fLength;
            hexBinaryDatatypeValidator.fMaxLength = this.fMaxLength;
            hexBinaryDatatypeValidator.fMinLength = this.fMinLength;
            hexBinaryDatatypeValidator.fPattern = this.fPattern;
            hexBinaryDatatypeValidator.fRegex = this.fRegex;
            hexBinaryDatatypeValidator.fEnumeration = this.fEnumeration;
            hexBinaryDatatypeValidator.fFacetsDefined = this.fFacetsDefined;
        }
        catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
            invalidDatatypeFacetException.printStackTrace();
        }
        return hexBinaryDatatypeValidator;
    }

    public int compare(String string, String string2) {
        if (string == null || string2 == null) {
            return -1;
        }
        if (string == string2 || string.equals(string2)) {
            return 0;
        }
        byte[] byArray = HexBin.decode(string.getBytes());
        byte[] byArray2 = HexBin.decode(string2.getBytes());
        if (byArray == null || byArray2 == null) {
            return -1;
        }
        int n = 0;
        while (n < Math.min(byArray.length, byArray2.length)) {
            if (byArray[n] < byArray2[n]) {
                return -1;
            }
            if (byArray[n] > byArray2[n]) {
                return 1;
            }
            ++n;
        }
        if (byArray.length == byArray2.length) {
            return 0;
        }
        return byArray.length > byArray2.length ? 1 : -1;
    }

    protected int getLength(String string) {
        int n = 0;
        try {
            try {
                n = HexBin.getDecodedDataLength(string.getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        catch (Throwable throwable) {}
        return n;
    }
}

