/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.components.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.graalvm.visualvm.lib.ui.components.table.EnhancedTableCellRenderer;

public class LabelTableCellRenderer
extends EnhancedTableCellRenderer {
    protected JLabel label;

    public LabelTableCellRenderer() {
        this(10);
    }

    public LabelTableCellRenderer(int horizontalAlignment) {
        this.setHorizontalAlignment(horizontalAlignment);
        this.label = new JLabel("", horizontalAlignment);
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
    }

    @Override
    public Component getTableCellRendererComponentPersistent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return new LabelTableCellRenderer(this.label.getHorizontalAlignment()).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    @Override
    protected void setRowForeground(Color c) {
        super.setRowForeground(c);
        this.label.setForeground(c);
    }

    @Override
    protected void setValue(JTable table, Object value, int row, int column) {
        if (table != null) {
            this.setFont(table.getFont());
        }
        this.label.setText(value == null ? "" : value.toString());
    }
}

