/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.parser.AbstractRecordParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordParser
extends AbstractRecordParser<Record> {
    private static final Logger LOGGER = LogManager.getLogger();

    public RecordParser(int startposition, byte[] array, ProtocolVersion version) {
        super(startposition, array, version);
    }

    @Override
    public Record parse() {
        LOGGER.debug("Parsing Record");
        Record record = new Record();
        this.parseContentType(record);
        ProtocolMessageType protocolMessageType = ProtocolMessageType.getContentType((Byte)record.getContentType().getValue());
        if (protocolMessageType == null) {
            protocolMessageType = ProtocolMessageType.UNKNOWN;
        }
        record.setContentMessageType(protocolMessageType);
        this.parseVersion(record);
        if (this.version.isDTLS()) {
            this.parseEpoch(record);
            this.parseSequenceNumber(record);
        }
        this.parseLength(record);
        this.parseProtocolMessageBytes(record);
        record.setCompleteRecordBytes(this.getAlreadyParsed());
        return record;
    }

    private void parseEpoch(Record record) {
        record.setEpoch(this.parseIntField(2));
        LOGGER.debug("Epoch: " + record.getEpoch().getValue());
    }

    private void parseSequenceNumber(Record record) {
        record.setSequenceNumber(this.parseBigIntField(6));
        LOGGER.debug("SequenceNumber: " + record.getSequenceNumber().getValue());
    }

    private void parseContentType(Record record) {
        record.setContentType(this.parseByteField(1));
        LOGGER.debug("ContentType: " + record.getContentType().getValue());
    }

    private void parseVersion(Record record) {
        record.setProtocolVersion(this.parseByteArrayField(2));
        LOGGER.debug("ProtocolVersion: " + ArrayConverter.bytesToHexString((byte[])((byte[])record.getProtocolVersion().getValue())));
    }

    private void parseLength(Record record) {
        record.setLength(this.parseIntField(2));
        LOGGER.debug("Length: " + record.getLength().getValue());
    }

    private void parseProtocolMessageBytes(Record record) {
        record.setProtocolMessageBytes(this.parseByteArrayField((Integer)record.getLength().getValue()));
        LOGGER.debug("ProtocolMessageBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])record.getProtocolMessageBytes().getValue())));
    }
}

