/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.SupplementalDataHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.supplementaldata.SupplementalDataEntry;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class SupplementalDataMessage
extends HandshakeMessage {
    @HoldsModifiableVariable
    private List<SupplementalDataEntry> entries;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger supplementalDataLength;
    @ModifiableVariableProperty
    private ModifiableByteArray supplementalDataBytes;

    public SupplementalDataMessage(Config config, LinkedList<SupplementalDataEntry> entries) {
        super(HandshakeMessageType.SUPPLEMENTAL_DATA);
        this.entries = new LinkedList<SupplementalDataEntry>(entries);
    }

    public SupplementalDataMessage(Config config) {
        this();
    }

    public SupplementalDataMessage() {
        super(HandshakeMessageType.SUPPLEMENTAL_DATA);
        this.entries = new LinkedList<SupplementalDataEntry>();
    }

    public List<SupplementalDataEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<SupplementalDataEntry> entries) {
        this.entries = entries;
    }

    public ModifiableInteger getSupplementalDataLength() {
        return this.supplementalDataLength;
    }

    public void setSupplementalDataLength(ModifiableInteger supplementalDataLength) {
        this.supplementalDataLength = supplementalDataLength;
    }

    public void setSupplementalDataLength(int supplementalDataLength) {
        this.supplementalDataLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.supplementalDataLength, (Integer)supplementalDataLength);
    }

    public ModifiableByteArray getSupplementalDataBytes() {
        return this.supplementalDataBytes;
    }

    public void setSupplementalDataBytes(ModifiableByteArray supplementalDataBytes) {
        this.supplementalDataBytes = supplementalDataBytes;
    }

    public void setSupplementalDataBytes(byte[] supplementalDataBytes) {
        this.supplementalDataBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.supplementalDataBytes, (byte[])supplementalDataBytes);
    }

    @Override
    public SupplementalDataHandler getHandler(TlsContext context) {
        return new SupplementalDataHandler(context);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SupplementalDataMessage:");
        sb.append("\n  Supplemental Data Length: ");
        if (this.supplementalDataLength != null && this.supplementalDataLength.getValue() != null) {
            sb.append(this.supplementalDataLength.getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  SupplementalDataEntries:\n");
        if (!this.entries.isEmpty()) {
            for (SupplementalDataEntry entry : this.entries) {
                sb.append("\n   Supplemental Data Type: ").append(entry.getSupplementalDataEntryType().getValue());
                sb.append("\n   Supplemental Data Length: ").append(entry.getSupplementalDataEntryLength().getValue());
                sb.append("\n   Supplemental Data : ").append(ArrayConverter.bytesToHexString((byte[])((byte[])entry.getSupplementalDataEntry().getValue())));
            }
        } else {
            sb.append("null");
        }
        return sb.toString();
    }
}

