/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientSensors;
import kafka.server.ControllerMutationQuota;
import kafka.server.ControllerMutationQuotaManager$;
import kafka.server.PermissiveControllerMutationQuota;
import kafka.server.QuotaType$ControllerMutation$;
import kafka.server.StrictControllerMutationQuota;
import kafka.server.UnboundedControllerMutationQuota$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.TokenBucket;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.Option;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005}u!B\r\u001b\u0011\u0003yb!B\u0011\u001b\u0011\u0003\u0011\u0003\"B\u0015\u0002\t\u0003Q\u0003\"B\u0016\u0002\t\u0003ac\u0001B\u0011\u001b\u0001\u0005C\u0001\"\u0012\u0003\u0003\u0006\u0004%IA\u0012\u0005\t\u0015\u0012\u0011\t\u0011)A\u0005\u000f\"AQ\u0007\u0002BC\u0002\u0013%1\n\u0003\u0005P\t\t\u0005\t\u0015!\u0003M\u0011!\u0001FA!b\u0001\n\u0013\t\u0006\u0002\u0003-\u0005\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011e#!Q1A\u0005\niC\u0001B\u001a\u0003\u0003\u0002\u0003\u0006Ia\u0017\u0005\tO\u0012\u0011)\u0019!C\u0005Q\"A1\u000f\u0002B\u0001B\u0003%\u0011\u000eC\u0003*\t\u0011\u0005A\u000fC\u0003|\t\u0011EC\u0010C\u0004\u0002\u000e\u0011!I!a\u0004\t\u000f\u0005MA\u0001\"\u0015\u0002\u0016!9\u0011Q\u0006\u0003\u0005B\u0005=\u0002bBA3\t\u0011\u0005\u0011q\r\u0005\b\u0003K\"A\u0011AA:\u0011\u001d\t\u0019\t\u0002C\u0001\u0003\u000bCq!a!\u0005\t\u0003\tY\tC\u0004\u0002\u0010\u0012!\t!!%\u0002=\r{g\u000e\u001e:pY2,'/T;uCRLwN\\)v_R\fW*\u00198bO\u0016\u0014(BA\u000e\u001d\u0003\u0019\u0019XM\u001d<fe*\tQ$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005\u0001\nQ\"\u0001\u000e\u0003=\r{g\u000e\u001e:pY2,'/T;uCRLwN\\)v_R\fW*\u00198bO\u0016\u00148CA\u0001$!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aH\u0001\u000fi\"\u0014x\u000e\u001e;mKRKW.Z't)\ri\u0003g\u0010\t\u0003I9J!aL\u0013\u0003\t1{gn\u001a\u0005\u0006c\r\u0001\rAM\u0001\u0002KB\u00111'P\u0007\u0002i)\u0011QGN\u0001\b[\u0016$(/[2t\u0015\t9\u0004(\u0001\u0004d_6lwN\u001c\u0006\u0003;eR!AO\u001e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0014aA8sO&\u0011a\b\u000e\u0002\u0018#V|G/\u0019,j_2\fG/[8o\u000bb\u001cW\r\u001d;j_:DQ\u0001Q\u0002A\u00025\na\u0001^5nK6\u001b8C\u0001\u0003C!\t\u00013)\u0003\u0002E5\t\u00112\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003\u0019\u0019wN\u001c4jOV\tq\t\u0005\u0002!\u0011&\u0011\u0011J\u0007\u0002\u0019\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'oQ8oM&<\u0017aB2p]\u001aLw\rI\u000b\u0002\u0019B\u00111'T\u0005\u0003\u001dR\u0012q!T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003\u0011!\u0018.\\3\u0016\u0003I\u0003\"a\u0015,\u000e\u0003QS!!\u0016\u001c\u0002\u000bU$\u0018\u000e\\:\n\u0005]#&\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\n\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\u0016\u0003m\u0003\"\u0001X2\u000f\u0005u\u000b\u0007C\u00010&\u001b\u0005y&B\u00011\u001f\u0003\u0019a$o\\8u}%\u0011!-J\u0001\u0007!J,G-\u001a4\n\u0005\u0011,'AB*ue&twM\u0003\u0002cK\u0005\tB\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\u0011\u0002\u001bE,x\u000e^1DC2d'-Y2l+\u0005I\u0007c\u0001\u0013kY&\u00111.\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00055\fX\"\u00018\u000b\u0005=\u0004\u0018!B9v_R\f'BA\u000e9\u0013\t\u0011hNA\nDY&,g\u000e^)v_R\f7)\u00197mE\u0006\u001c7.\u0001\brk>$\u0018mQ1mY\n\f7m\u001b\u0011\u0015\rU4x\u000f_={!\t\u0001C\u0001C\u0003F\u001f\u0001\u0007q\tC\u00036\u001f\u0001\u0007A\nC\u0003Q\u001f\u0001\u0007!\u000bC\u0003Z\u001f\u0001\u00071\fC\u0003h\u001f\u0001\u0007\u0011.A\u000bdY&,g\u000e^)v_R\fW*\u001a;sS\u000et\u0015-\\3\u0015\u0007u\f\u0019\u0001\u0005\u0002\u007f\u007f6\ta'C\u0002\u0002\u0002Y\u0012!\"T3ue&\u001cg*Y7f\u0011\u001d\t)\u0001\u0005a\u0001\u0003\u000f\tq\"];pi\u0006lU\r\u001e:jGR\u000bwm\u001d\t\u00069\u0006%1lW\u0005\u0004\u0003\u0017)'aA'ba\u0006!2\r\\5f]R\u0014\u0016\r^3NKR\u0014\u0018n\u0019(b[\u0016$2!`A\t\u0011\u001d\t)!\u0005a\u0001\u0003\u000f\tAC]3hSN$XM])v_R\fW*\u001a;sS\u000e\u001cH\u0003BA\f\u0003S!B!!\u0007\u0002 A\u0019A%a\u0007\n\u0007\u0005uQE\u0001\u0003V]&$\bbBA\u0011%\u0001\u0007\u00111E\u0001\u0007g\u0016t7o\u001c:\u0011\u0007M\n)#C\u0002\u0002(Q\u0012aaU3og>\u0014\bbBA\u0016%\u0001\u0007\u0011qA\u0001\u000b[\u0016$(/[2UC\u001e\u001c\u0018A\u0007:fG>\u0014H-\u00118e\u000f\u0016$H\u000b\u001b:piRdW\rV5nK6\u001bHCCA\u0019\u0003o\t)&!\u0017\u0002dA\u0019A%a\r\n\u0007\u0005UREA\u0002J]RDq!!\u000f\u0014\u0001\u0004\tY$A\u0004tKN\u001c\u0018n\u001c8\u0011\t\u0005u\u0012q\n\b\u0005\u0003\u007f\tIE\u0004\u0003\u0002B\u0005\u0015cb\u00010\u0002D%\tQ$C\u0002\u0002Hq\tqA\\3uo>\u00148.\u0003\u0003\u0002L\u00055\u0013A\u0004*fcV,7\u000f^\"iC:tW\r\u001c\u0006\u0004\u0003\u000fb\u0012\u0002BA)\u0003'\u0012qaU3tg&|gN\u0003\u0003\u0002L\u00055\u0003BBA,'\u0001\u00071,\u0001\u0005dY&,g\u000e^%e\u0011\u001d\tYf\u0005a\u0001\u0003;\nQA^1mk\u0016\u00042\u0001JA0\u0013\r\t\t'\n\u0002\u0007\t>,(\r\\3\t\u000b\u0001\u001b\u0002\u0019A\u0017\u0002#9,wo\u0015;sS\u000e$\u0018+^8uC\u001a{'\u000f\u0006\u0004\u0002j\u0005=\u0014\u0011\u000f\t\u0004A\u0005-\u0014bAA75\t92i\u001c8ue>dG.\u001a:NkR\fG/[8o#V|G/\u0019\u0005\b\u0003s!\u0002\u0019AA\u001e\u0011\u0019\t9\u0006\u0006a\u00017R!\u0011\u0011NA;\u0011\u001d\t9(\u0006a\u0001\u0003s\nqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002|\u0005}d\u0002BA?\u0003\u0013j!!!\u0014\n\t\u0005\u0005\u00151\u000b\u0002\b%\u0016\fX/Z:u\u0003UqWm\u001e)fe6L7o]5wKF+x\u000e^1G_J$b!!\u001b\u0002\b\u0006%\u0005bBA\u001d-\u0001\u0007\u00111\b\u0005\u0007\u0003/2\u0002\u0019A.\u0015\t\u0005%\u0014Q\u0012\u0005\b\u0003o:\u0002\u0019AA=\u0003-qWm^)v_R\fgi\u001c:\u0015\r\u0005%\u00141SAK\u0011\u001d\t9\b\u0007a\u0001\u0003sBq!a&\u0019\u0001\u0004\tI*\u0001\ntiJL7\r^*j]\u000e,g+\u001a:tS>t\u0007c\u0001\u0013\u0002\u001c&\u0019\u0011QT\u0013\u0003\u000bMCwN\u001d;")
public class ControllerMutationQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final Time time;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> quotaCallback;

    public static long throttleTimeMs(QuotaViolationException e, long timeMs) {
        return ControllerMutationQuotaManager$.MODULE$.throttleTimeMs(e, timeMs);
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> quotaCallback() {
        return this.quotaCallback;
    }

    @Override
    public MetricName clientQuotaMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("tokens", "ControllerMutation", "Tracking remaining tokens in the token bucket per user/client-id", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    private MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("mutation-rate", "ControllerMutation", "Tracking mutation-rate per user/client-id", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerQuotaMetrics(Map<String, String> metricTags, Sensor sensor) {
        void add_stat;
        void add_metricName;
        Rate rate = new Rate();
        MetricName metricName = this.clientRateMetricName(metricTags);
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
        metricName = null;
        rate = null;
        sensor.add(this.clientQuotaMetricName(metricTags), (MeasurableStat)new TokenBucket(), this.getQuotaMetricConfig(metricTags));
    }

    @Override
    public int recordAndGetThrottleTimeMs(RequestChannel.Session session, String clientId, double value, long timeMs) {
        Sensor quotaSensor = this.getOrCreateQuotaSensors(session, clientId).quotaSensor();
        try {
            synchronized (quotaSensor) {
                quotaSensor.checkQuotas(timeMs);
                quotaSensor.record(value, timeMs, false);
            }
            return 0;
        }
        catch (QuotaViolationException e) {
            int throttleTimeMs = (int)ControllerMutationQuotaManager$.MODULE$.throttleTimeMs(e, timeMs);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Quota violated for sensor (").append(quotaSensor.name()).append("). Delay time: (").append(throttleTimeMs).append(")").toString());
            return throttleTimeMs;
        }
    }

    public ControllerMutationQuota newStrictQuotaFor(RequestChannel.Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new StrictControllerMutationQuota(this.time(), clientSensors.quotaSensor());
        }
        return UnboundedControllerMutationQuota$.MODULE$;
    }

    public ControllerMutationQuota newStrictQuotaFor(RequestChannel.Request request) {
        return this.newStrictQuotaFor(request.session(), request.header().clientId());
    }

    public ControllerMutationQuota newPermissiveQuotaFor(RequestChannel.Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new PermissiveControllerMutationQuota(this.time(), clientSensors.quotaSensor());
        }
        return UnboundedControllerMutationQuota$.MODULE$;
    }

    public ControllerMutationQuota newPermissiveQuotaFor(RequestChannel.Request request) {
        return this.newPermissiveQuotaFor(request.session(), request.header().clientId());
    }

    public ControllerMutationQuota newQuotaFor(RequestChannel.Request request, short strictSinceVersion) {
        if (request.header().apiVersion() >= strictSinceVersion) {
            return this.newStrictQuotaFor(request);
        }
        return this.newPermissiveQuotaFor(request);
    }

    public ControllerMutationQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> quotaCallback) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        this.quotaCallback = quotaCallback;
        super(config, metrics, QuotaType$ControllerMutation$.MODULE$, time, threadNamePrefix, quotaCallback);
    }
}

