/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.vector;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.spatial.vector.PointVectorStrategy;
import org.locationtech.spatial4j.distance.DistanceCalculator;
import org.locationtech.spatial4j.shape.Point;

public class DistanceValueSource
extends DoubleValuesSource {
    private PointVectorStrategy strategy;
    private final Point from;
    private final double multiplier;
    private final double nullValue;

    public DistanceValueSource(PointVectorStrategy strategy, Point from, double multiplier) {
        this.strategy = strategy;
        this.from = from;
        this.multiplier = multiplier;
        this.nullValue = 180.0 * multiplier;
    }

    public String toString() {
        return "DistanceValueSource(" + this.strategy + ", " + this.from + ")";
    }

    public DoubleValues getValues(LeafReaderContext readerContext, DoubleValues scores) throws IOException {
        LeafReader reader = readerContext.reader();
        final NumericDocValues ptX = DocValues.getNumeric((LeafReader)reader, (String)this.strategy.getFieldNameX());
        final NumericDocValues ptY = DocValues.getNumeric((LeafReader)reader, (String)this.strategy.getFieldNameY());
        return DoubleValues.withDefault((DoubleValues)new DoubleValues(){
            private final Point from;
            private final DistanceCalculator calculator;
            {
                this.from = DistanceValueSource.this.from;
                this.calculator = DistanceValueSource.this.strategy.getSpatialContext().getDistCalc();
            }

            public double doubleValue() throws IOException {
                double x = Double.longBitsToDouble(ptX.longValue());
                double y = Double.longBitsToDouble(ptY.longValue());
                return this.calculator.distance(this.from, x, y) * DistanceValueSource.this.multiplier;
            }

            public boolean advanceExact(int doc) throws IOException {
                return ptX.advanceExact(doc) && ptY.advanceExact(doc);
            }
        }, (double)this.nullValue);
    }

    public boolean needsScores() {
        return false;
    }

    public boolean isCacheable(LeafReaderContext ctx) {
        return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{this.strategy.getFieldNameX(), this.strategy.getFieldNameY()});
    }

    public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DistanceValueSource that = (DistanceValueSource)((Object)o);
        if (!this.from.equals(that.from)) {
            return false;
        }
        if (!this.strategy.equals(that.strategy)) {
            return false;
        }
        return this.multiplier == that.multiplier;
    }

    public int hashCode() {
        return this.from.hashCode();
    }
}

