/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.crossdc.update.processor;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import org.apache.solr.core.SolrCore;
import org.apache.solr.metrics.SolrMetricsContext;

public class ProducerMetrics {
    private final Counter local;
    private final Counter localError;
    private final Counter submitted;
    private final Counter submitError;
    private final Histogram documentSize;
    private final Counter documentTooLarge;

    public ProducerMetrics(SolrMetricsContext solrMetricsContext, SolrCore solrCore) {
        this.local = solrMetricsContext.counter(String.valueOf(solrCore), new String[]{"local", "crossdc", "producer"});
        this.localError = solrMetricsContext.counter(String.valueOf(solrCore), new String[]{"local", "crossdc", "producer", "errors"});
        this.submitted = solrMetricsContext.counter(String.valueOf(solrCore), new String[]{"submitted", "crossdc", "producer"});
        this.submitError = solrMetricsContext.counter(String.valueOf(solrCore), new String[]{"submit", "crossdc", "producer", "errors"});
        this.documentSize = solrMetricsContext.histogram(String.valueOf(solrCore), new String[]{"documentSize", "crossdc", "producer"});
        this.documentTooLarge = solrMetricsContext.counter(String.valueOf(solrCore), new String[]{"documentTooLarge", "crossdc", "producer", "errors"});
    }

    public Counter getLocal() {
        return this.local;
    }

    public Counter getLocalError() {
        return this.localError;
    }

    public Counter getSubmitted() {
        return this.submitted;
    }

    public Counter getSubmitError() {
        return this.submitError;
    }

    public Histogram getDocumentSize() {
        return this.documentSize;
    }

    public Counter getDocumentTooLarge() {
        return this.documentTooLarge;
    }
}

