/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.notifications.model.BaseModel;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 12\u00020\u0001:\u00011B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B;\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\u0002\u0010\fBM\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\r\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\r\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\r\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\u0019J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u00c6\u0003JW\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\b\b\u0002\u0010\n\u001a\u00020\u00062\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0006H\u00d6\u0001J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011\u00a8\u00062"}, d2={"Lorg/opensearch/commons/alerting/model/DocLevelQuery;", "Lorg/opensearch/commons/notifications/model/BaseModel;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "id", "", "name", "fields", "", "query", "tags", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/util/List;)V", "", "queryFieldNames", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getFields", "()Ljava/util/List;", "getId", "()Ljava/lang/String;", "getName", "getQuery", "getQueryFieldNames", "getTags", "asTemplateArg", "", "", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "common-utils"})
@SourceDebugExtension(value={"SMAP\nDocLevelQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocLevelQuery.kt\norg/opensearch/commons/alerting/model/DocLevelQuery\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,195:1\n37#2,2:196\n37#2,2:198\n37#2,2:200\n*S KotlinDebug\n*F\n+ 1 DocLevelQuery.kt\norg/opensearch/commons/alerting/model/DocLevelQuery\n*L\n66#1:196,2\n68#1:198,2\n69#1:200,2\n*E\n"})
public final class DocLevelQuery
implements BaseModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final List<String> fields;
    @NotNull
    private final String query;
    @NotNull
    private final List<String> tags;
    @NotNull
    private final List<String> queryFieldNames;
    @NotNull
    public static final String QUERY_ID_FIELD = "id";
    @NotNull
    public static final String NAME_FIELD = "name";
    @NotNull
    public static final String FIELDS_FIELD = "fields";
    @NotNull
    public static final String QUERY_FIELD = "query";
    @NotNull
    public static final String TAGS_FIELD = "tags";
    @NotNull
    public static final String QUERY_FIELD_NAMES_FIELD = "query_field_names";
    @NotNull
    public static final String NO_ID = "";
    @NotNull
    private static final List<String> INVALID_CHARACTERS;
    @NotNull
    private static final Regex QUERY_NAME_REGEX;

    public DocLevelQuery(@NotNull String id, @NotNull String name, @NotNull List<String> fields, @NotNull String query, @NotNull List<String> tags, @NotNull List<String> queryFieldNames) {
        Intrinsics.checkNotNullParameter((Object)id, (String)QUERY_ID_FIELD);
        Intrinsics.checkNotNullParameter((Object)name, (String)NAME_FIELD);
        Intrinsics.checkNotNullParameter(fields, (String)FIELDS_FIELD);
        Intrinsics.checkNotNullParameter((Object)query, (String)QUERY_FIELD);
        Intrinsics.checkNotNullParameter(tags, (String)TAGS_FIELD);
        Intrinsics.checkNotNullParameter(queryFieldNames, (String)"queryFieldNames");
        this.id = id;
        this.name = name;
        this.fields = fields;
        this.query = query;
        this.tags = tags;
        this.queryFieldNames = queryFieldNames;
        DocLevelQuery.Companion.validateQueryName(this.name);
        for (String tag : this.tags) {
            DocLevelQuery.Companion.validateQueryTag(tag);
        }
    }

    public /* synthetic */ DocLevelQuery(String string, String string2, List list, String string3, List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            String string4 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            string = string4;
        }
        if ((n & 0x10) != 0) {
            list2 = new ArrayList();
        }
        if ((n & 0x20) != 0) {
            list3 = new ArrayList();
        }
        this(string, string2, list, string3, list2, list3);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<String> getFields() {
        return this.fields;
    }

    @NotNull
    public final String getQuery() {
        return this.query;
    }

    @NotNull
    public final List<String> getTags() {
        return this.tags;
    }

    @NotNull
    public final List<String> getQueryFieldNames() {
        return this.queryFieldNames;
    }

    public DocLevelQuery(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
        List list = sin.readStringList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readStringList(...)");
        String string3 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"readString(...)");
        List list2 = sin.readStringList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"readStringList(...)");
        List list3 = sin.readStringList();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"readStringList(...)");
        this(string, string2, list, string3, list2, list3);
    }

    @NotNull
    public final Map<String, Object> asTemplateArg() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)QUERY_ID_FIELD, (Object)this.id), TuplesKt.to((Object)NAME_FIELD, (Object)this.name), TuplesKt.to((Object)FIELDS_FIELD, this.fields), TuplesKt.to((Object)QUERY_FIELD, (Object)this.query), TuplesKt.to((Object)TAGS_FIELD, this.tags), TuplesKt.to((Object)QUERY_FIELD_NAMES_FIELD, this.queryFieldNames)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.id);
        out.writeString(this.name);
        out.writeStringCollection((Collection)this.fields);
        out.writeString(this.query);
        out.writeStringCollection((Collection)this.tags);
        out.writeStringCollection((Collection)this.queryFieldNames);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Collection $this$toTypedArray$iv = this.fields;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        XContentBuilder xContentBuilder = builder.startObject().field(QUERY_ID_FIELD, this.id).field(NAME_FIELD, this.name).field(FIELDS_FIELD, (Object)thisCollection$iv.toArray(new String[0])).field(QUERY_FIELD, this.query);
        $this$toTypedArray$iv = this.tags;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        XContentBuilder xContentBuilder2 = xContentBuilder.field(TAGS_FIELD, (Object)thisCollection$iv.toArray(new String[0]));
        $this$toTypedArray$iv = this.queryFieldNames;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        xContentBuilder2.field(QUERY_FIELD_NAMES_FIELD, (Object)thisCollection$iv.toArray(new String[0])).endObject();
        return builder;
    }

    public DocLevelQuery(@NotNull String id, @NotNull String name, @NotNull List<String> fields, @NotNull String query, @NotNull List<String> tags) {
        Intrinsics.checkNotNullParameter((Object)id, (String)QUERY_ID_FIELD);
        Intrinsics.checkNotNullParameter((Object)name, (String)NAME_FIELD);
        Intrinsics.checkNotNullParameter(fields, (String)FIELDS_FIELD);
        Intrinsics.checkNotNullParameter((Object)query, (String)QUERY_FIELD);
        Intrinsics.checkNotNullParameter(tags, (String)TAGS_FIELD);
        this(id, name, fields, query, tags, CollectionsKt.emptyList());
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final List<String> component3() {
        return this.fields;
    }

    @NotNull
    public final String component4() {
        return this.query;
    }

    @NotNull
    public final List<String> component5() {
        return this.tags;
    }

    @NotNull
    public final List<String> component6() {
        return this.queryFieldNames;
    }

    @NotNull
    public final DocLevelQuery copy(@NotNull String id, @NotNull String name, @NotNull List<String> fields, @NotNull String query, @NotNull List<String> tags, @NotNull List<String> queryFieldNames) {
        Intrinsics.checkNotNullParameter((Object)id, (String)QUERY_ID_FIELD);
        Intrinsics.checkNotNullParameter((Object)name, (String)NAME_FIELD);
        Intrinsics.checkNotNullParameter(fields, (String)FIELDS_FIELD);
        Intrinsics.checkNotNullParameter((Object)query, (String)QUERY_FIELD);
        Intrinsics.checkNotNullParameter(tags, (String)TAGS_FIELD);
        Intrinsics.checkNotNullParameter(queryFieldNames, (String)"queryFieldNames");
        return new DocLevelQuery(id, name, fields, query, tags, queryFieldNames);
    }

    public static /* synthetic */ DocLevelQuery copy$default(DocLevelQuery docLevelQuery, String string, String string2, List list, String string3, List list2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            string = docLevelQuery.id;
        }
        if ((n & 2) != 0) {
            string2 = docLevelQuery.name;
        }
        if ((n & 4) != 0) {
            list = docLevelQuery.fields;
        }
        if ((n & 8) != 0) {
            string3 = docLevelQuery.query;
        }
        if ((n & 0x10) != 0) {
            list2 = docLevelQuery.tags;
        }
        if ((n & 0x20) != 0) {
            list3 = docLevelQuery.queryFieldNames;
        }
        return docLevelQuery.copy(string, string2, list, string3, list2, list3);
    }

    @NotNull
    public String toString() {
        return "DocLevelQuery(id=" + this.id + ", name=" + this.name + ", fields=" + this.fields + ", query=" + this.query + ", tags=" + this.tags + ", queryFieldNames=" + this.queryFieldNames + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + ((Object)this.fields).hashCode();
        result = result * 31 + this.query.hashCode();
        result = result * 31 + ((Object)this.tags).hashCode();
        result = result * 31 + ((Object)this.queryFieldNames).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DocLevelQuery)) {
            return false;
        }
        DocLevelQuery docLevelQuery = (DocLevelQuery)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)docLevelQuery.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)docLevelQuery.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.fields, docLevelQuery.fields)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.query, (Object)docLevelQuery.query)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tags, docLevelQuery.tags)) {
            return false;
        }
        return Intrinsics.areEqual(this.queryFieldNames, docLevelQuery.queryFieldNames);
    }

    @JvmStatic
    @NotNull
    public static final DocLevelQuery parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @JvmStatic
    @NotNull
    public static final DocLevelQuery readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    static {
        Object[] objectArray = new String[]{" ", "[", "]", "{", "}", "(", ")"};
        INVALID_CHARACTERS = CollectionsKt.listOf((Object[])objectArray);
        QUERY_NAME_REGEX = new Regex("^.{1,256}$");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/opensearch/commons/alerting/model/DocLevelQuery$Companion;", "", "()V", "FIELDS_FIELD", "", "INVALID_CHARACTERS", "", "getINVALID_CHARACTERS", "()Ljava/util/List;", "NAME_FIELD", "NO_ID", "QUERY_FIELD", "QUERY_FIELD_NAMES_FIELD", "QUERY_ID_FIELD", "QUERY_NAME_REGEX", "Lkotlin/text/Regex;", "getQUERY_NAME_REGEX", "()Lkotlin/text/Regex;", "TAGS_FIELD", "parse", "Lorg/opensearch/commons/alerting/model/DocLevelQuery;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "readFrom", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "validateQueryName", "", "stringVal", "validateQueryTag", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getINVALID_CHARACTERS() {
            return INVALID_CHARACTERS;
        }

        @NotNull
        public final Regex getQUERY_NAME_REGEX() {
            return QUERY_NAME_REGEX;
        }

        @JvmStatic
        @NotNull
        public final DocLevelQuery parse(@NotNull XContentParser xcp) throws IOException {
            String string;
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String id = string2;
            String query = null;
            String name = null;
            List tags = new ArrayList();
            List fields = new ArrayList();
            List queryFieldNames = new ArrayList();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block16: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string3 = fieldName;
                if (string3 == null) continue;
                int n = -1;
                switch (string3.hashCode()) {
                    case 2069447372: {
                        if (string3.equals(DocLevelQuery.QUERY_FIELD_NAMES_FIELD)) {
                            n = 1;
                        }
                        break;
                    }
                    case 107944136: {
                        if (string3.equals(DocLevelQuery.QUERY_FIELD)) {
                            n = 2;
                        }
                        break;
                    }
                    case 3373707: {
                        if (string3.equals(DocLevelQuery.NAME_FIELD)) {
                            n = 3;
                        }
                        break;
                    }
                    case 3355: {
                        if (string3.equals(DocLevelQuery.QUERY_ID_FIELD)) {
                            n = 4;
                        }
                        break;
                    }
                    case -1274708295: {
                        if (string3.equals(DocLevelQuery.FIELDS_FIELD)) {
                            n = 5;
                        }
                        break;
                    }
                    case 3552281: {
                        if (string3.equals(DocLevelQuery.TAGS_FIELD)) {
                            n = 6;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 4: {
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"text(...)");
                        continue block16;
                    }
                    case 3: {
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"text(...)");
                        this.validateQueryName(name);
                        continue block16;
                    }
                    case 2: {
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"text(...)");
                        continue block16;
                    }
                    case 6: {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                            String tag = xcp.text();
                            Intrinsics.checkNotNull((Object)tag);
                            this.validateQueryTag(tag);
                            tags.add(tag);
                        }
                        continue block16;
                    }
                    case 5: {
                        String field;
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                            field = xcp.text();
                            Intrinsics.checkNotNull((Object)field);
                            fields.add(field);
                        }
                        continue block16;
                    }
                    case 1: {
                        String field;
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                            field = xcp.text();
                            Intrinsics.checkNotNull((Object)field);
                            queryFieldNames.add(field);
                        }
                        continue block16;
                    }
                }
            }
            String string4 = name;
            if (string4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)DocLevelQuery.NAME_FIELD);
                string4 = null;
            }
            if ((string = query) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)DocLevelQuery.QUERY_FIELD);
                string = null;
            }
            return new DocLevelQuery(id, string4, fields, string, tags, queryFieldNames);
        }

        @JvmStatic
        @NotNull
        public final DocLevelQuery readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new DocLevelQuery(sin);
        }

        private final void validateQueryTag(String stringVal) {
            for (String inValidChar : this.getINVALID_CHARACTERS()) {
                if (!StringsKt.contains$default((CharSequence)stringVal, (CharSequence)inValidChar, (boolean)false, (int)2, null)) continue;
                throw new IllegalArgumentException("The query tag, " + stringVal + ", contains an invalid character: [' ','[',']','{','}','(',')']");
            }
        }

        private final void validateQueryName(String stringVal) {
            CharSequence charSequence = stringVal;
            if (!this.getQUERY_NAME_REGEX().matches(charSequence)) {
                throw new IllegalArgumentException("The query name, " + stringVal + ", should be between 1 - 256 characters.");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

