/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ubi;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilter;
import org.opensearch.action.support.ActionFilterChain;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.env.Environment;
import org.opensearch.search.SearchHit;
import org.opensearch.tasks.Task;
import org.opensearch.telemetry.tracing.Span;
import org.opensearch.telemetry.tracing.SpanBuilder;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.transport.client.Client;
import org.opensearch.ubi.QueryRequest;
import org.opensearch.ubi.QueryResponse;
import org.opensearch.ubi.UbiSearchResponse;
import org.opensearch.ubi.ext.UbiParameters;

public class UbiActionFilter
implements ActionFilter {
    private static final Logger LOGGER = LogManager.getLogger(UbiActionFilter.class);
    private final Client client;
    private final Environment environment;
    private final Tracer tracer;

    public UbiActionFilter(Client client, Environment environment, Tracer tracer) {
        this.client = client;
        this.environment = environment;
        this.tracer = tracer;
    }

    public int order() {
        return Integer.MAX_VALUE;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, final Request request, final ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        if (!(request instanceof SearchRequest) && !(request instanceof MultiSearchRequest)) {
            chain.proceed(task, action, request, listener);
            return;
        }
        chain.proceed(task, action, request, new ActionListener<Response>(this){
            final /* synthetic */ UbiActionFilter this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(Response response) {
                if (request instanceof MultiSearchRequest) {
                    MultiSearchRequest multiSearchRequest = (MultiSearchRequest)request;
                    for (SearchRequest searchRequest : multiSearchRequest.requests()) {
                        this.this$0.handleSearchRequest(searchRequest, (ActionResponse)response);
                    }
                }
                if (request instanceof SearchRequest) {
                    response = this.this$0.handleSearchRequest((SearchRequest)request, (ActionResponse)response);
                }
                listener.onResponse(response);
            }

            public void onFailure(Exception ex) {
                listener.onFailure(ex);
            }
        });
    }

    private ActionResponse handleSearchRequest(SearchRequest searchRequest, ActionResponse response) {
        UbiParameters ubiParameters;
        if (response instanceof SearchResponse && (ubiParameters = UbiParameters.getUbiParameters(searchRequest)) != null) {
            String queryId = ubiParameters.getQueryId();
            String userQuery = ubiParameters.getUserQuery();
            String userId = ubiParameters.getClientId();
            String objectIdField = ubiParameters.getObjectIdField();
            String application = ubiParameters.getApplication();
            Map<String, String> queryAttributes = ubiParameters.getQueryAttributes();
            String query = searchRequest.source().toString();
            LinkedList<String> queryResponseHitIds = new LinkedList<String>();
            for (SearchHit hit : ((SearchResponse)response).getHits()) {
                if (objectIdField == null || objectIdField.isEmpty()) {
                    queryResponseHitIds.add(String.valueOf(hit.docId()));
                    continue;
                }
                Map source = hit.getSourceAsMap();
                queryResponseHitIds.add((String)source.get(objectIdField));
            }
            String queryResponseId = UUID.randomUUID().toString();
            QueryResponse queryResponse = new QueryResponse(queryId, queryResponseId, queryResponseHitIds);
            QueryRequest queryRequest = new QueryRequest(queryId, userQuery, userId, query, application, queryAttributes, queryResponse);
            String dataPrepperUrl = this.environment.settings().get("ubi.dataprepper.url");
            if (dataPrepperUrl != null) {
                this.sendToDataPrepper(dataPrepperUrl, queryRequest);
            } else {
                this.indexQuery(queryRequest);
            }
            SearchResponse searchResponse = (SearchResponse)response;
            response = new UbiSearchResponse(searchResponse.getInternalResponse(), searchResponse.getScrollId(), searchResponse.getTotalShards(), searchResponse.getSuccessfulShards(), searchResponse.getSkippedShards(), searchResponse.getTook().millis(), searchResponse.getShardFailures(), searchResponse.getClusters(), queryId);
        }
        return response;
    }

    private void sendToDataPrepper(String dataPrepperUrl, QueryRequest queryRequest) {
        LOGGER.debug("Sending query to DataPrepper at {}", (Object)dataPrepperUrl);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(dataPrepperUrl);
            httpPost.setEntity((HttpEntity)new StringEntity(queryRequest.toString()));
            httpPost.setHeader("Content-type", "application/json");
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                int status = response.getStatusLine().getStatusCode();
                if (status != 200) {
                    LOGGER.error("Unexpected response status from Data Prepper: " + status);
                }
            }
            catch (Exception ex) {
                LOGGER.error("Unable to send query to Data Prepper", (Throwable)ex);
            }
        }
        catch (IOException ex) {
            LOGGER.error("Failed to send query to Data Prepper", (Throwable)ex);
        }
    }

    private void indexQuery(QueryRequest queryRequest) {
        LOGGER.debug("Indexing query ID {} with response ID {}", (Object)queryRequest.getQueryId(), (Object)queryRequest.getQueryResponse().getQueryResponseId());
        HashMap<String, Object> source = new HashMap<String, Object>();
        source.put("timestamp", queryRequest.getTimestamp());
        source.put("query_id", queryRequest.getQueryId());
        source.put("query_response_id", queryRequest.getQueryResponse().getQueryResponseId());
        source.put("query_response_hit_ids", queryRequest.getQueryResponse().getQueryResponseHitIds());
        source.put("client_id", queryRequest.getClientId());
        source.put("application", queryRequest.getApplication());
        source.put("user_query", queryRequest.getUserQuery());
        source.put("query_attributes", queryRequest.getQueryAttributes());
        if (queryRequest.getQuery() != null) {
            source.put("query", queryRequest.getQuery());
        }
        IndexRequest indexRequest = new IndexRequest();
        indexRequest.index("ubi_queries");
        indexRequest.source(source, (MediaType)XContentType.JSON);
        this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(this){

            public void onResponse(IndexResponse indexResponse) {
            }

            public void onFailure(Exception e) {
                LOGGER.error("Unable to index query into ubi_queries.", (Throwable)e);
            }
        });
    }

    private void sendOtelTrace(Task task, Tracer tracer, QueryRequest queryRequest) {
        Span span = tracer.startSpan(SpanBuilder.from((Task)task, (String)"ubi_search"));
        span.addAttribute("ubi.user_id", queryRequest.getQueryId());
        span.addAttribute("ubi.query", queryRequest.getQuery());
        span.addAttribute("ubi.user_query", queryRequest.getUserQuery());
        span.addAttribute("ubi.client_id", queryRequest.getClientId());
        span.addAttribute("ubi.timestamp", queryRequest.getTimestamp());
        for (String key : queryRequest.getQueryAttributes().keySet()) {
            span.addAttribute("ubi.attribute." + key, queryRequest.getQueryAttributes().get(key));
        }
        span.addAttribute("ubi.query_response.response_id", queryRequest.getQueryResponse().getQueryResponseId());
        span.addAttribute("ubi.query_response.query_id", queryRequest.getQueryResponse().getQueryId());
        span.addAttribute("ubi.query_response.response_id", String.join((CharSequence)",", queryRequest.getQueryResponse().getQueryResponseHitIds()));
        span.endSpan();
    }
}

