/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.parse;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.parse.ParseExpression;
import shaded.com.google.common.collect.ImmutableList;

public class RegexExpression
extends ParseExpression {
    private static final Logger log = LogManager.getLogger(RegexExpression.class);
    private static final Pattern GROUP_PATTERN = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>");
    private final Pattern regexPattern;

    public RegexExpression(Expression sourceField, Expression pattern, Expression identifier) {
        super("regex", sourceField, pattern, identifier);
        this.regexPattern = Pattern.compile(pattern.valueOf().stringValue());
    }

    @Override
    ExprValue parseValue(ExprValue value) throws ExpressionEvaluationException {
        String rawString = value.stringValue();
        Matcher matcher = this.regexPattern.matcher(rawString);
        if (matcher.matches()) {
            return new ExprStringValue(matcher.group(this.identifierStr));
        }
        log.debug("failed to extract pattern {} from input ***", (Object)this.regexPattern.pattern());
        return new ExprStringValue("");
    }

    public static List<String> getNamedGroupCandidates(String pattern) {
        ImmutableList.Builder namedGroups = ImmutableList.builder();
        Matcher m = GROUP_PATTERN.matcher(pattern);
        while (m.find()) {
            namedGroups.add((Object)m.group(1));
        }
        return namedGroups.build();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegexExpression)) {
            return false;
        }
        RegexExpression other = (RegexExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RegexExpression;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "RegexExpression(regexPattern=" + String.valueOf(this.getRegexPattern()) + ")";
    }

    @Generated
    public Pattern getRegexPattern() {
        return this.regexPattern;
    }
}

