/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Line2D;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicFormattedTextFieldUI;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.jhotdraw.gui.plaf.palette.BackdropBorder;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;

public class PaletteFormattedTextFieldUI
extends BasicFormattedTextFieldUI {
    private Color errorIndicatorForeground;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PaletteFormattedTextFieldUI();
    }

    @Override
    public View create(Element element) {
        return new FieldView(element){

            protected Shape adjustAllocationXX(Shape shape) {
                if (shape != null) {
                    Container container;
                    Rectangle rectangle = shape.getBounds();
                    int n = (int)this.getPreferredSpan(1);
                    int n2 = (int)this.getPreferredSpan(0);
                    if (rectangle.height != n) {
                        int n3 = rectangle.height - n;
                        rectangle.y += n3 / 2;
                        rectangle.height -= n3;
                    }
                    if ((container = this.getContainer()) instanceof JTextField) {
                        int n4;
                        JTextField jTextField = (JTextField)container;
                        BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
                        int n5 = Math.max(n2, rectangle.width);
                        int n6 = boundedRangeModel.getValue();
                        if (n6 + (n4 = Math.min(n5, rectangle.width - 1)) > n5) {
                            n6 = n5 - n4;
                        }
                        boundedRangeModel.setRangeProperties(n6, n4, boundedRangeModel.getMinimum(), n5, false);
                        if (n2 < rectangle.width) {
                            int n7 = rectangle.width - 1 - n2;
                            int n8 = ((JTextField)container).getHorizontalAlignment();
                            if (n8 == 10) {
                                n8 = 2;
                            } else if (n8 == 11) {
                                n8 = 4;
                            }
                            switch (n8) {
                                case 0: {
                                    rectangle.x += n7 / 2;
                                    rectangle.width -= n7;
                                    break;
                                }
                                case 4: {
                                    rectangle.x += n7;
                                    rectangle.width -= n7;
                                }
                            }
                        } else {
                            rectangle.width = n2;
                            rectangle.x -= boundedRangeModel.getValue();
                        }
                    }
                    return rectangle;
                }
                return null;
            }

            @Override
            public void paint(Graphics graphics, Shape shape) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                JFormattedTextField jFormattedTextField = (JFormattedTextField)PaletteFormattedTextFieldUI.this.getComponent();
                if (!jFormattedTextField.isEditValid()) {
                    Rectangle rectangle = (Rectangle)shape;
                    graphics2D.setColor(PaletteFormattedTextFieldUI.this.errorIndicatorForeground);
                    graphics2D.setStroke(new BasicStroke(2.5f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.5f));
                    graphics2D.draw(new Line2D.Float(rectangle.x, (float)(rectangle.y + rectangle.height) - 0.5f, rectangle.x + rectangle.width - 1, (float)(rectangle.y + rectangle.height) - 0.5f));
                }
                super.paint(graphics2D, shape);
            }
        };
    }

    @Override
    protected void installDefaults() {
        Insets insets;
        Border border;
        Color color;
        Color color2;
        Color color3;
        Color color4;
        Color color5;
        Color color6;
        JTextComponent jTextComponent = this.getComponent();
        PaletteLookAndFeel paletteLookAndFeel = PaletteLookAndFeel.getInstance();
        String string = this.getPropertyPrefix();
        Font font = jTextComponent.getFont();
        if (font == null || font instanceof UIResource) {
            jTextComponent.setFont(paletteLookAndFeel.getFont(string + ".font"));
        }
        if ((color6 = jTextComponent.getBackground()) == null || color6 instanceof UIResource) {
            jTextComponent.setBackground(paletteLookAndFeel.getColor(string + ".background"));
        }
        if ((color5 = jTextComponent.getForeground()) == null || color5 instanceof UIResource) {
            jTextComponent.setForeground(paletteLookAndFeel.getColor(string + ".foreground"));
        }
        if ((color4 = jTextComponent.getCaretColor()) == null || color4 instanceof UIResource) {
            jTextComponent.setCaretColor(paletteLookAndFeel.getColor(string + ".caretForeground"));
        }
        if ((color3 = jTextComponent.getSelectionColor()) == null || color3 instanceof UIResource) {
            jTextComponent.setSelectionColor(paletteLookAndFeel.getColor(string + ".selectionBackground"));
        }
        if ((color2 = jTextComponent.getSelectedTextColor()) == null || color2 instanceof UIResource) {
            jTextComponent.setSelectedTextColor(paletteLookAndFeel.getColor(string + ".selectionForeground"));
        }
        if ((color = jTextComponent.getDisabledTextColor()) == null || color instanceof UIResource) {
            jTextComponent.setDisabledTextColor(paletteLookAndFeel.getColor(string + ".inactiveForeground"));
        }
        if ((border = jTextComponent.getBorder()) == null || border instanceof UIResource) {
            jTextComponent.setBorder(paletteLookAndFeel.getBorder(string + ".border"));
        }
        if ((insets = jTextComponent.getMargin()) == null || insets instanceof UIResource) {
            jTextComponent.setMargin(paletteLookAndFeel.getInsets(string + ".margin"));
        }
        this.errorIndicatorForeground = paletteLookAndFeel.getColor(string + ".errorIndicatorForeground");
        jTextComponent.setOpaque(paletteLookAndFeel.getBoolean(string + ".opaque"));
    }

    @Override
    protected void paintSafely(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        super.paintSafely(graphics2D);
    }

    @Override
    public void paintBackground(Graphics graphics) {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent.getBorder() instanceof BackdropBorder) {
            BackdropBorder backdropBorder = (BackdropBorder)jTextComponent.getBorder();
            backdropBorder.getBackdropBorder().paintBorder(jTextComponent, graphics, 0, 0, jTextComponent.getWidth(), jTextComponent.getHeight());
        } else {
            super.paintBackground(graphics);
        }
    }
}

