/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.scala.internal;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ScalaRuntimeHelper {
    private static final Pattern SCALA_JAR_PATTERN = Pattern.compile("scala3?-(\\w.*?)-(\\d.*).jar");

    @Nullable
    public static File findScalaJar(Iterable<File> classpath, String appendix) {
        for (File file : classpath) {
            Matcher matcher = SCALA_JAR_PATTERN.matcher(file.getName());
            if (!matcher.matches() || !matcher.group(1).equals(appendix)) continue;
            return file;
        }
        return null;
    }

    @Nullable
    public static String getScalaVersion(File scalaJar) {
        Matcher matcher = SCALA_JAR_PATTERN.matcher(scalaJar.getName());
        return matcher.matches() ? matcher.group(2) : null;
    }

    public static boolean isScala3(String scalaVersion) {
        return scalaVersion.startsWith("3.");
    }
}

