/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.model.monitor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class ThreatIntelTrigger
implements Writeable,
ToXContentObject {
    public static final String DATA_SOURCES = "data_sources";
    public static final String IOC_TYPES = "ioc_types";
    List<String> dataSources;
    List<String> iocTypes;

    public ThreatIntelTrigger(List<String> dataSources, List<String> iocTypes) {
        this.dataSources = dataSources == null ? Collections.emptyList() : dataSources;
        this.iocTypes = iocTypes == null ? Collections.emptyList() : iocTypes;
    }

    public ThreatIntelTrigger(StreamInput sin) throws IOException {
        this(sin.readStringList(), sin.readStringList());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.dataSources);
        out.writeStringCollection(this.iocTypes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(DATA_SOURCES, this.dataSources).field(IOC_TYPES, this.iocTypes).endObject();
    }

    public static ThreatIntelTrigger readFrom(StreamInput sin) throws IOException {
        return new ThreatIntelTrigger(sin);
    }

    public static ThreatIntelTrigger parse(XContentParser xcp) throws IOException {
        ArrayList<String> iocTypes = new ArrayList<String>();
        ArrayList<String> dataSources = new ArrayList<String>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block8: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "ioc_types": {
                    ArrayList<String> vals = new ArrayList<String>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        vals.add(xcp.text());
                    }
                    iocTypes.addAll(vals);
                    continue block8;
                }
                case "data_sources": {
                    ArrayList<String> ds = new ArrayList<String>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        ds.add(xcp.text());
                    }
                    dataSources.addAll(ds);
                    continue block8;
                }
            }
            xcp.skipChildren();
        }
        return new ThreatIntelTrigger(dataSources, iocTypes);
    }

    public List<String> getDataSources() {
        return this.dataSources;
    }

    public List<String> getIocTypes() {
        return this.iocTypes;
    }
}

