/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.resthandler;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.securityanalytics.action.GetDetectorAction;
import org.opensearch.securityanalytics.action.GetDetectorRequest;
import org.opensearch.transport.client.node.NodeClient;

public class RestGetDetectorAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestGetDetectorAction.class);

    public String getName() {
        return "get_detector_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.getDefault(), "%s/{%s}", "/_plugins/_security_analytics/detectors", "detector_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String detectorId = request.param("detector_id", "");
        if (detectorId == null || detectorId.isEmpty()) {
            throw new IllegalArgumentException("missing id");
        }
        GetDetectorRequest req = new GetDetectorRequest(detectorId, RestActions.parseVersion((RestRequest)request));
        return channel -> client.execute((ActionType)GetDetectorAction.INSTANCE, (ActionRequest)req, (ActionListener)new RestToXContentListener(channel));
    }
}

