/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.resthandler;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.securityanalytics.action.DeleteCorrelationRuleAction;
import org.opensearch.securityanalytics.action.DeleteCorrelationRuleRequest;
import org.opensearch.transport.client.node.NodeClient;

public class RestDeleteCorrelationRuleAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestDeleteCorrelationRuleAction.class);

    public String getName() {
        return "delete_correlation_rule_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, String.format(Locale.getDefault(), "%s/{correlation_rule_id}", "/_plugins/_security_analytics/correlation/rules")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        log.debug(String.format(Locale.getDefault(), "%s %s/{correlation_rule_id}", request.method(), "/_plugins/_security_analytics/correlation/rules"));
        String ruleID = request.param("correlation_rule_id");
        WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.parse((String)request.param("refresh", WriteRequest.RefreshPolicy.IMMEDIATE.getValue()));
        DeleteCorrelationRuleRequest deleteRequest = new DeleteCorrelationRuleRequest(ruleID, refreshPolicy);
        return channel -> client.execute((ActionType)DeleteCorrelationRuleAction.INSTANCE, (ActionRequest)deleteRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

