/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class UpdateIndexMappingsRequest
extends ActionRequest
implements ToXContentObject {
    public static final String INDEX_NAME_FIELD = "index_name";
    public static final String FIELD = "field";
    public static final String ALIAS = "alias";
    String indexName;
    String field;
    String alias;

    public UpdateIndexMappingsRequest(String indexName, String field, String alias) {
        this.indexName = indexName;
        this.field = field;
        this.alias = alias;
    }

    public UpdateIndexMappingsRequest(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readString(), sin.readString());
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indexName == null || this.indexName.length() == 0) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.getDefault(), "%s is missing", INDEX_NAME_FIELD), validationException);
        }
        if (this.field == null || this.field.length() == 0) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.getDefault(), "%s is missing", FIELD), (ActionRequestValidationException)validationException);
        }
        if (this.alias == null || this.alias.length() == 0) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.getDefault(), "%s is missing", ALIAS), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.indexName);
        out.writeString(this.field);
        out.writeString(this.alias);
    }

    public static UpdateIndexMappingsRequest parse(XContentParser xcp) throws IOException {
        String indexName = null;
        String field = null;
        String alias = null;
        if (xcp.currentToken() == null) {
            xcp.nextToken();
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block10: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "index_name": {
                    indexName = xcp.text();
                    continue block10;
                }
                case "field": {
                    field = xcp.text();
                    continue block10;
                }
                case "alias": {
                    alias = xcp.text();
                    continue block10;
                }
            }
            xcp.skipChildren();
        }
        return new UpdateIndexMappingsRequest(indexName, field, alias);
    }

    public UpdateIndexMappingsRequest indexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public UpdateIndexMappingsRequest field(String field) {
        this.field = field;
        return this;
    }

    public UpdateIndexMappingsRequest alias(String alias) {
        this.alias = alias;
        return this;
    }

    public String getField() {
        return this.field;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(INDEX_NAME_FIELD, this.indexName).field(FIELD, this.field).field(ALIAS, this.alias).endObject();
    }
}

