/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.utils;

import java.time.format.DateTimeParseException;
import org.opensearch.common.time.DateFormatter;

public class DateValidationUtil {
    public static DateValidationResult validateDate(String date) {
        if (date.equals("") || date == null) {
            return new DateValidationResult(true, null);
        }
        DateFormatter formatter = DateFormatter.forPattern((String)"yyyy-MM-dd");
        try {
            formatter.parse(date);
        }
        catch (IllegalArgumentException e) {
            return new DateValidationResult(false, "failed to parse date field [" + date + "] with format [yyyy-MM-dd]");
        }
        catch (DateTimeParseException e) {
            return new DateValidationResult(false, "failed to parse date field [" + date + "] with format [yyyy-MM-dd]");
        }
        return new DateValidationResult(true, null);
    }

    public static class DateValidationResult {
        private final boolean valid;
        private final String errorMessage;

        public DateValidationResult(boolean valid, String errorMessage) {
            this.valid = valid;
            this.errorMessage = errorMessage;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

