/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.apache.spark.annotation.Unstable;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.errors.DataTypeErrors$;
import org.apache.spark.sql.internal.SqlApiConf$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction1;

@Unstable
public final class Decimal$
implements Serializable {
    public static final Decimal$ MODULE$ = new Decimal$();
    private static int[] minBytesForPrecision;
    private static final Enumeration.Value ROUND_HALF_UP;
    private static final Enumeration.Value ROUND_HALF_EVEN;
    private static final Enumeration.Value ROUND_CEILING;
    private static final Enumeration.Value ROUND_FLOOR;
    private static final int MAX_INT_DIGITS;
    private static final int MAX_LONG_DIGITS;
    private static final long[] POW_10;
    private static final MathContext org$apache$spark$sql$types$Decimal$$MATH_CONTEXT;
    private static final Decimal ZERO;
    private static final Decimal ONE;
    private static volatile boolean bitmap$0;

    static {
        ROUND_HALF_UP = BigDecimal.RoundingMode$.MODULE$.HALF_UP();
        ROUND_HALF_EVEN = BigDecimal.RoundingMode$.MODULE$.HALF_EVEN();
        ROUND_CEILING = BigDecimal.RoundingMode$.MODULE$.CEILING();
        ROUND_FLOOR = BigDecimal.RoundingMode$.MODULE$.FLOOR();
        MAX_INT_DIGITS = 9;
        MAX_LONG_DIGITS = 18;
        POW_10 = (long[])Array$.MODULE$.tabulate(MODULE$.MAX_LONG_DIGITS() + 1, (Function1)(JFunction1.mcJI.sp & Serializable)i -> (long)package$.MODULE$.pow(10.0, (double)i), (ClassTag)ClassTag$.MODULE$.Long());
        org$apache$spark$sql$types$Decimal$$MATH_CONTEXT = new MathContext(DecimalType$.MODULE$.MAX_PRECISION() + 1, RoundingMode.DOWN);
        ZERO = MODULE$.apply(0);
        ONE = MODULE$.apply(1);
    }

    public Enumeration.Value ROUND_HALF_UP() {
        return ROUND_HALF_UP;
    }

    public Enumeration.Value ROUND_HALF_EVEN() {
        return ROUND_HALF_EVEN;
    }

    public Enumeration.Value ROUND_CEILING() {
        return ROUND_CEILING;
    }

    public Enumeration.Value ROUND_FLOOR() {
        return ROUND_FLOOR;
    }

    public int MAX_INT_DIGITS() {
        return MAX_INT_DIGITS;
    }

    public int MAX_LONG_DIGITS() {
        return MAX_LONG_DIGITS;
    }

    public long[] POW_10() {
        return POW_10;
    }

    public MathContext org$apache$spark$sql$types$Decimal$$MATH_CONTEXT() {
        return org$apache$spark$sql$types$Decimal$$MATH_CONTEXT;
    }

    public Decimal ZERO() {
        return ZERO;
    }

    public Decimal ONE() {
        return ONE;
    }

    public Decimal apply(double value) {
        return new Decimal().set(BigDecimal$.MODULE$.double2bigDecimal(value));
    }

    public Decimal apply(long value) {
        return new Decimal().set(value);
    }

    public Decimal apply(int value) {
        return new Decimal().set(value);
    }

    public Decimal apply(scala.math.BigDecimal value) {
        return new Decimal().set(value);
    }

    public Decimal apply(BigDecimal value) {
        return new Decimal().set(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(value));
    }

    public Decimal apply(BigInteger value) {
        return new Decimal().set(value);
    }

    public Decimal apply(BigInt value) {
        return new Decimal().set(value.bigInteger());
    }

    public Decimal apply(scala.math.BigDecimal value, int precision, int scale) {
        return new Decimal().set(value, precision, scale);
    }

    public Decimal apply(BigDecimal value, int precision, int scale) {
        return new Decimal().set(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(value), precision, scale);
    }

    public Decimal apply(long unscaled, int precision, int scale) {
        return new Decimal().set(unscaled, precision, scale);
    }

    public Decimal apply(String value) {
        return new Decimal().set(scala.package$.MODULE$.BigDecimal().apply(value));
    }

    public Decimal fromDecimal(Object value) {
        Decimal decimal;
        Object object = value;
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            decimal = this.apply(bigDecimal);
        } else if (object instanceof scala.math.BigDecimal) {
            scala.math.BigDecimal bigDecimal = (scala.math.BigDecimal)object;
            decimal = this.apply(bigDecimal);
        } else if (object instanceof BigInt) {
            BigInt bigInt = (BigInt)object;
            decimal = this.apply(bigInt);
        } else if (object instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)object;
            decimal = this.apply(bigInteger);
        } else if (object instanceof Decimal) {
            Decimal decimal2;
            decimal = decimal2 = (Decimal)object;
        } else {
            throw new MatchError(object);
        }
        return decimal;
    }

    private int numDigitsInIntegralPart(BigDecimal bigDecimal) {
        return bigDecimal.precision() - bigDecimal.scale();
    }

    private BigDecimal stringToJavaBigDecimal(UTF8String str) {
        return new BigDecimal(str.toString().trim());
    }

    public Decimal fromString(UTF8String str) {
        Decimal decimal;
        block3: {
            try {
                BigDecimal bigDecimal = this.stringToJavaBigDecimal(str);
                if (this.numDigitsInIntegralPart(bigDecimal) > DecimalType$.MODULE$.MAX_PRECISION() && !SqlApiConf$.MODULE$.get().allowNegativeScaleOfDecimalEnabled()) {
                    decimal = null;
                    break block3;
                }
                decimal = this.apply(bigDecimal);
            }
            catch (NumberFormatException numberFormatException) {
                decimal = null;
            }
        }
        return decimal;
    }

    public Decimal fromStringANSI(UTF8String str, DecimalType to, SQLQueryContext context) {
        Decimal decimal;
        try {
            BigDecimal bigDecimal = this.stringToJavaBigDecimal(str);
            if (this.numDigitsInIntegralPart(bigDecimal) > DecimalType$.MODULE$.MAX_PRECISION() && !SqlApiConf$.MODULE$.get().allowNegativeScaleOfDecimalEnabled()) {
                throw DataTypeErrors$.MODULE$.outOfDecimalTypeRangeError(str);
            }
            decimal = this.apply(bigDecimal);
        }
        catch (NumberFormatException numberFormatException) {
            throw DataTypeErrors$.MODULE$.invalidInputInCastToNumberError(to, str, context);
        }
        return decimal;
    }

    public DecimalType fromStringANSI$default$2() {
        return DecimalType$.MODULE$.USER_DEFAULT();
    }

    public SQLQueryContext fromStringANSI$default$3() {
        return null;
    }

    public Decimal createUnsafe(long unscaled, int precision, int scale) {
        DecimalType$.MODULE$.checkNegativeScale(scale);
        Decimal dec = new Decimal();
        dec.org$apache$spark$sql$types$Decimal$$longVal_$eq(unscaled);
        dec.org$apache$spark$sql$types$Decimal$$_precision_$eq(precision);
        dec.org$apache$spark$sql$types$Decimal$$_scale_$eq(scale);
        return dec;
    }

    public int maxPrecisionForBytes(int numBytes) {
        return (int)Math.round(Math.floor(Math.log10(Math.pow(2.0, 8 * numBytes - 1) - 1.0)));
    }

    private int[] minBytesForPrecision$lzycompute() {
        Decimal$ decimal$ = this;
        synchronized (decimal$) {
            if (!bitmap$0) {
                minBytesForPrecision = (int[])Array$.MODULE$.tabulate(39, (Function1)(JFunction1.mcII.sp & Serializable)precision -> MODULE$.computeMinBytesForPrecision(precision), (ClassTag)ClassTag$.MODULE$.Int());
                bitmap$0 = true;
            }
        }
        return minBytesForPrecision;
    }

    public int[] minBytesForPrecision() {
        return !bitmap$0 ? this.minBytesForPrecision$lzycompute() : minBytesForPrecision;
    }

    /*
     * WARNING - void declaration
     */
    private int computeMinBytesForPrecision(int precision) {
        void var2_2;
        int numBytes = 1;
        while (package$.MODULE$.pow(2.0, (double)(8 * numBytes - 1)) < package$.MODULE$.pow(10.0, (double)precision)) {
            ++numBytes;
        }
        return (int)var2_2;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Decimal$.class);
    }

    private Decimal$() {
    }
}

