/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.customcodecs;

import com.intel.qat.QatZipper;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.Compressor;
import org.apache.lucene.codecs.compressing.Decompressor;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.opensearch.index.codec.customcodecs.QatZipperFactory;
import org.opensearch.index.codec.customcodecs.backward_codecs.lucene99.Lucene99QatCodec;

public class QatCompressionMode
extends CompressionMode {
    private static final int NUM_SUB_BLOCKS = 10;
    private final QatZipper.Algorithm algorithm;
    private final int compressionLevel;
    private final Supplier<QatZipper.Mode> supplier;

    protected QatCompressionMode() {
        this(QatZipper.Algorithm.LZ4, Lucene99QatCodec.DEFAULT_COMPRESSION_LEVEL, () -> Lucene99QatCodec.DEFAULT_QAT_MODE);
    }

    protected QatCompressionMode(QatZipper.Algorithm algorithm) {
        this(algorithm, Lucene99QatCodec.DEFAULT_COMPRESSION_LEVEL, () -> Lucene99QatCodec.DEFAULT_QAT_MODE);
    }

    protected QatCompressionMode(QatZipper.Algorithm algorithm, int compressionLevel) {
        this(algorithm, compressionLevel, () -> Lucene99QatCodec.DEFAULT_QAT_MODE);
    }

    protected QatCompressionMode(QatZipper.Algorithm algorithm, int compressionLevel, Supplier<QatZipper.Mode> supplier) {
        this.algorithm = algorithm;
        this.compressionLevel = compressionLevel;
        this.supplier = supplier;
    }

    public Compressor newCompressor() {
        return new QatCompressor(this.algorithm, this.compressionLevel, this.supplier.get());
    }

    public Decompressor newDecompressor() {
        return new QatDecompressor(this.algorithm, this.supplier.get());
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    private static final class QatCompressor
    extends Compressor {
        private byte[] compressedBuffer = BytesRef.EMPTY_BYTES;
        private final QatZipper qatZipper;

        public QatCompressor(QatZipper.Algorithm algorithm, int compressionLevel, QatZipper.Mode qatMode) {
            this.qatZipper = QatZipperFactory.createInstance(algorithm, compressionLevel, qatMode, QatZipper.PollingMode.PERIODICAL);
        }

        private void compress(byte[] bytes, int offset, int length, DataOutput out) throws IOException {
            assert (offset >= 0) : "Offset value must be greater than 0.";
            int blockLength = (length + 10 - 1) / 10;
            out.writeVInt(blockLength);
            int end = offset + length;
            assert (end >= 0) : "Buffer read size must be greater than 0.";
            for (int start = offset; start < end; start += blockLength) {
                int l = Math.min(blockLength, end - start);
                if (l == 0) {
                    out.writeVInt(0);
                    return;
                }
                int maxCompressedLength = this.qatZipper.maxCompressedLength((long)l);
                this.compressedBuffer = ArrayUtil.grow((byte[])this.compressedBuffer, (int)maxCompressedLength);
                int compressedSize = this.qatZipper.compress(bytes, start, l, this.compressedBuffer, 0, this.compressedBuffer.length);
                out.writeVInt(compressedSize);
                out.writeBytes(this.compressedBuffer, compressedSize);
            }
        }

        public void compress(ByteBuffersDataInput buffersInput, DataOutput out) throws IOException {
            int length = (int)buffersInput.length();
            byte[] bytes = new byte[length];
            buffersInput.readBytes(bytes, 0, length);
            this.compress(bytes, 0, length, out);
        }

        public void close() throws IOException {
        }
    }

    private static final class QatDecompressor
    extends Decompressor {
        private byte[] compressed;
        private final QatZipper qatZipper;
        private final QatZipper.Mode qatMode;
        private final QatZipper.Algorithm algorithm;

        public QatDecompressor(QatZipper.Algorithm algorithm, QatZipper.Mode qatMode) {
            this.algorithm = algorithm;
            this.qatMode = qatMode;
            this.compressed = BytesRef.EMPTY_BYTES;
            this.qatZipper = QatZipperFactory.createInstance(algorithm, qatMode, QatZipper.PollingMode.PERIODICAL);
        }

        public void decompress(DataInput in, int originalLength, int offset, int length, BytesRef bytes) throws IOException {
            int compressedLength;
            assert (offset + length <= originalLength) : "Buffer read size must be within limit.";
            if (length == 0) {
                bytes.length = 0;
                return;
            }
            int blockLength = in.readVInt();
            bytes.length = 0;
            bytes.offset = 0;
            int offsetInBlock = 0;
            int offsetInBytesRef = offset;
            while (offsetInBlock + blockLength < offset) {
                compressedLength = in.readVInt();
                in.skipBytes((long)compressedLength);
                offsetInBlock += blockLength;
                offsetInBytesRef -= blockLength;
            }
            while (offsetInBlock < offset + length) {
                compressedLength = in.readVInt();
                if (compressedLength == 0) {
                    return;
                }
                this.compressed = ArrayUtil.grow((byte[])this.compressed, (int)compressedLength);
                in.readBytes(this.compressed, 0, compressedLength);
                int l = Math.min(blockLength, originalLength - offsetInBlock);
                bytes.bytes = ArrayUtil.grow((byte[])bytes.bytes, (int)(bytes.length + l));
                int uncompressed = this.qatZipper.decompress(this.compressed, 0, compressedLength, bytes.bytes, bytes.length, l);
                bytes.length += uncompressed;
                offsetInBlock += blockLength;
            }
            bytes.offset = offsetInBytesRef;
            bytes.length = length;
            assert (bytes.isValid()) : "Decompression output is corrupted.";
        }

        public Decompressor clone() {
            return new QatDecompressor(this.algorithm, this.qatMode);
        }
    }
}

