/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.flint;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public enum FlintIndexState {
    EMPTY("empty"),
    CREATING("creating"),
    ACTIVE("active"),
    REFRESHING("refreshing"),
    CANCELLING("cancelling"),
    DELETING("deleting"),
    DELETED("deleted"),
    RECOVERING("recovering"),
    VACUUMING("vacuuming"),
    UPDATING("updating"),
    FAILED("failed"),
    UNKNOWN("unknown"),
    NONE("none");

    private final String state;
    private static Map<String, FlintIndexState> STATES;

    private FlintIndexState(String state) {
        this.state = state;
    }

    public static FlintIndexState fromString(String key) {
        for (FlintIndexState ss : FlintIndexState.values()) {
            if (!ss.getState().toLowerCase(Locale.ROOT).equals(key)) continue;
            return ss;
        }
        return UNKNOWN;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    static {
        STATES = Arrays.stream(FlintIndexState.values()).collect(Collectors.toMap(t -> t.name().toLowerCase(), t -> t));
    }
}

