/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.sql.legacy.antlr.semantic.types.Type;
import org.opensearch.sql.legacy.antlr.semantic.types.base.OpenSearchDataType;
import org.opensearch.sql.legacy.antlr.semantic.types.special.Product;
import org.opensearch.sql.legacy.executor.format.Schema;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;

public class ColumnTypeProvider {
    private final List<Schema.Type> typeList;
    private static final Map<OpenSearchDataType, Schema.Type> TYPE_MAP = new ImmutableMap.Builder().put((Object)OpenSearchDataType.SHORT, (Object)Schema.Type.SHORT).put((Object)OpenSearchDataType.LONG, (Object)Schema.Type.LONG).put((Object)OpenSearchDataType.INTEGER, (Object)Schema.Type.INTEGER).put((Object)OpenSearchDataType.FLOAT, (Object)Schema.Type.FLOAT).put((Object)OpenSearchDataType.DOUBLE, (Object)Schema.Type.DOUBLE).put((Object)OpenSearchDataType.KEYWORD, (Object)Schema.Type.KEYWORD).put((Object)OpenSearchDataType.TEXT, (Object)Schema.Type.TEXT).put((Object)OpenSearchDataType.STRING, (Object)Schema.Type.TEXT).put((Object)OpenSearchDataType.DATE, (Object)Schema.Type.DATE).put((Object)OpenSearchDataType.BOOLEAN, (Object)Schema.Type.BOOLEAN).put((Object)OpenSearchDataType.UNKNOWN, (Object)Schema.Type.DOUBLE).build();
    public static final Schema.Type COLUMN_DEFAULT_TYPE = Schema.Type.DOUBLE;

    public ColumnTypeProvider(Type type) {
        this.typeList = this.convertOutputColumnType(type);
    }

    public ColumnTypeProvider() {
        this.typeList = new ArrayList<Schema.Type>();
    }

    public Schema.Type get(int index) {
        if (this.typeList.isEmpty()) {
            return COLUMN_DEFAULT_TYPE;
        }
        return this.typeList.get(index);
    }

    private List<Schema.Type> convertOutputColumnType(Type type) {
        if (type instanceof Product) {
            List<Type> types = ((Product)type).getTypes();
            return types.stream().map(t -> this.convertType((Type)t)).collect(Collectors.toList());
        }
        if (type instanceof OpenSearchDataType) {
            return ImmutableList.of((Object)((Object)this.convertType(type)));
        }
        return ImmutableList.of((Object)((Object)COLUMN_DEFAULT_TYPE));
    }

    private Schema.Type convertType(Type type) {
        try {
            return TYPE_MAP.getOrDefault(type, COLUMN_DEFAULT_TYPE);
        }
        catch (Exception e) {
            return COLUMN_DEFAULT_TYPE;
        }
    }
}

