/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.expression;

import lombok.Generated;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.calcite.plan.OpenSearchConstants;

public class Alias
extends UnresolvedExpression {
    private final String name;
    private final UnresolvedExpression delegated;
    private final String alias;

    public Alias(String name, UnresolvedExpression expr) {
        this(name, expr, false);
    }

    public Alias(String name, UnresolvedExpression expr, String alias) {
        this(name, expr, alias, false);
    }

    public Alias(String name, UnresolvedExpression expr, boolean metaDataFieldAllowed) {
        this(name, expr, null, metaDataFieldAllowed);
    }

    private Alias(String name, UnresolvedExpression expr, String alias, boolean metadataFieldAllowed) {
        if (!metadataFieldAllowed && OpenSearchConstants.METADATAFIELD_TYPE_MAP.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Cannot use metadata field [%s] as the alias.", name));
        }
        this.name = name;
        this.delegated = expr;
        this.alias = alias;
    }

    public static Alias newAliasAllowMetaMetaField(String name, UnresolvedExpression expr, String alias) {
        return new Alias(name, expr, alias, true);
    }

    @Override
    public <T, C> T accept(AbstractNodeVisitor<T, C> nodeVisitor, C context) {
        return nodeVisitor.visitAlias(this, context);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Alias)) {
            return false;
        }
        Alias other = (Alias)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        UnresolvedExpression this$delegated = this.getDelegated();
        UnresolvedExpression other$delegated = other.getDelegated();
        if (this$delegated == null ? other$delegated != null : !((Object)this$delegated).equals(other$delegated)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        return !(this$alias == null ? other$alias != null : !this$alias.equals(other$alias));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Alias;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        UnresolvedExpression $delegated = this.getDelegated();
        result = result * 59 + ($delegated == null ? 43 : ((Object)$delegated).hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public UnresolvedExpression getDelegated() {
        return this.delegated;
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Override
    @Generated
    public String toString() {
        return "Alias(name=" + this.getName() + ", delegated=" + String.valueOf(this.getDelegated()) + ", alias=" + this.getAlias() + ")";
    }
}

