/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCheckpointDataNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int STAGE;
    public static final int PCHECKPOINTMARKER;

    public VkCheckpointDataNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCheckpointDataNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCheckpointDataNV.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkCheckpointDataNV.npNext(this.address());
    }

    @NativeType(value="VkPipelineStageFlagBits")
    public int stage() {
        return VkCheckpointDataNV.nstage(this.address());
    }

    @NativeType(value="void *")
    public long pCheckpointMarker() {
        return VkCheckpointDataNV.npCheckpointMarker(this.address());
    }

    public VkCheckpointDataNV sType(@NativeType(value="VkStructureType") int value) {
        VkCheckpointDataNV.nsType(this.address(), value);
        return this;
    }

    public VkCheckpointDataNV sType$Default() {
        return this.sType(1000206000);
    }

    public VkCheckpointDataNV pNext(@NativeType(value="void *") long value) {
        VkCheckpointDataNV.npNext(this.address(), value);
        return this;
    }

    public VkCheckpointDataNV set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkCheckpointDataNV set(VkCheckpointDataNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCheckpointDataNV malloc() {
        return (VkCheckpointDataNV)VkCheckpointDataNV.wrap(VkCheckpointDataNV.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkCheckpointDataNV calloc() {
        return (VkCheckpointDataNV)VkCheckpointDataNV.wrap(VkCheckpointDataNV.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkCheckpointDataNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkCheckpointDataNV)VkCheckpointDataNV.wrap(VkCheckpointDataNV.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkCheckpointDataNV create(long address) {
        return (VkCheckpointDataNV)VkCheckpointDataNV.wrap(VkCheckpointDataNV.class, (long)address);
    }

    @Nullable
    public static VkCheckpointDataNV createSafe(long address) {
        return address == 0L ? null : (VkCheckpointDataNV)VkCheckpointDataNV.wrap(VkCheckpointDataNV.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkCheckpointDataNV.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkCheckpointDataNV.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkCheckpointDataNV.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCheckpointDataNV.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkCheckpointDataNV.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkCheckpointDataNV.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkCheckpointDataNV.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkCheckpointDataNV mallocStack() {
        return VkCheckpointDataNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkCheckpointDataNV callocStack() {
        return VkCheckpointDataNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkCheckpointDataNV mallocStack(MemoryStack stack) {
        return VkCheckpointDataNV.malloc(stack);
    }

    @Deprecated
    public static VkCheckpointDataNV callocStack(MemoryStack stack) {
        return VkCheckpointDataNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkCheckpointDataNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkCheckpointDataNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkCheckpointDataNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkCheckpointDataNV.calloc(capacity, stack);
    }

    public static VkCheckpointDataNV malloc(MemoryStack stack) {
        return (VkCheckpointDataNV)VkCheckpointDataNV.wrap(VkCheckpointDataNV.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkCheckpointDataNV calloc(MemoryStack stack) {
        return (VkCheckpointDataNV)VkCheckpointDataNV.wrap(VkCheckpointDataNV.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkCheckpointDataNV.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkCheckpointDataNV.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nstage(long struct) {
        return UNSAFE.getInt(null, struct + (long)STAGE);
    }

    public static long npCheckpointMarker(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PCHECKPOINTMARKER));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkCheckpointDataNV.__struct((Struct.Member[])new Struct.Member[]{VkCheckpointDataNV.__member((int)4), VkCheckpointDataNV.__member((int)POINTER_SIZE), VkCheckpointDataNV.__member((int)4), VkCheckpointDataNV.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        STAGE = layout.offsetof(2);
        PCHECKPOINTMARKER = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkCheckpointDataNV, Buffer>
    implements NativeResource {
        private static final VkCheckpointDataNV ELEMENT_FACTORY = VkCheckpointDataNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkCheckpointDataNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCheckpointDataNV.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkCheckpointDataNV.npNext(this.address());
        }

        @NativeType(value="VkPipelineStageFlagBits")
        public int stage() {
            return VkCheckpointDataNV.nstage(this.address());
        }

        @NativeType(value="void *")
        public long pCheckpointMarker() {
            return VkCheckpointDataNV.npCheckpointMarker(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCheckpointDataNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000206000);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkCheckpointDataNV.npNext(this.address(), value);
            return this;
        }
    }
}

