/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.utilities;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.model.Plugin;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PomTransformer {
    static final Pattern[] POSTPROCESS_PATTERNS = new Pattern[]{Pattern.compile("(<\\?xml[^>]*\\?>)?(\\s*)<"), Pattern.compile("(\\s*)<project([^>]*)>"), Pattern.compile("\\s*$")};
    static final Pattern EOL_PATTERN = Pattern.compile("\r?\n");
    private final Path path;
    private final Charset charset;

    public PomTransformer(Path path, Charset charset) {
        this.path = path;
        this.charset = charset;
    }

    public void transform(Transformation ... transformations) {
        this.transform(Arrays.asList(transformations));
    }

    public void transform(Collection<Transformation> transformations) {
        PomTransformer.transform(transformations, this.path, () -> {
            try {
                return Files.readString(this.path, this.charset);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Could not read DOM from [%s]", this.path), e);
            }
        }, xml -> {
            try {
                Files.write(this.path, xml.getBytes(this.charset), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Could not write DOM from [%s]", this.path), e);
            }
        });
    }

    static void transform(Collection<Transformation> edits, Path path, Supplier<String> source, Consumer<String> outConsumer) {
        String result;
        Document document;
        String src = source.get();
        try {
            DOMResult domResult = new DOMResult();
            TransformerFactory.newInstance().newTransformer().transform(new StreamSource(new StringReader(source.get())), domResult);
            document = (Document)domResult.getNode();
        }
        catch (TransformerException | TransformerFactoryConfigurationError e) {
            throw new RuntimeException(String.format("Could not read DOM from [%s]", path), e);
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        TransformationContext context = new TransformationContext(path, document, PomTransformer.detectIndentation(document, xPath), xPath);
        for (Transformation edit : edits) {
            edit.perform(document, context);
        }
        try {
            StringWriter out = new StringWriter();
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), new StreamResult(out));
            result = out.toString();
        }
        catch (TransformerException | TransformerFactoryConfigurationError e) {
            throw new RuntimeException(String.format("Could not write DOM from [%s]", path), e);
        }
        String eol = PomTransformer.detectEol(src);
        result = EOL_PATTERN.matcher(result).replaceAll(eol);
        result = PomTransformer.postprocess(src, result);
        outConsumer.accept(result);
    }

    static String postprocess(String src, String result) {
        for (Pattern p : POSTPROCESS_PATTERNS) {
            Matcher srcMatcher = p.matcher(src);
            if (!srcMatcher.find()) continue;
            String replacement = Matcher.quoteReplacement(srcMatcher.group());
            result = p.matcher(result).replaceFirst(replacement);
        }
        return result;
    }

    static String detectIndentation(Node document, XPath xPath) {
        try {
            String ws = (String)xPath.evaluate(PomTransformer.anyNs("project") + "/*[1]/preceding-sibling::text()[last()]", document, XPathConstants.STRING);
            if (ws != null && !ws.isEmpty()) {
                int i;
                block5: for (i = ws.length() - 1; i >= 0; --i) {
                    switch (ws.charAt(i)) {
                        case '\t': 
                        case ' ': {
                            continue block5;
                        }
                    }
                }
                return ws.substring(i + 1);
            }
            return "    ";
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    static String detectEol(String src) {
        return src.indexOf(13) >= 0 ? "\r\n" : "\n";
    }

    static String anyNs(String ... elements) {
        StringBuilder sb = new StringBuilder();
        for (String e : elements) {
            sb.append("/*[local-name()='").append(e).append("']");
        }
        return sb.toString();
    }

    public static class TransformationContext {
        private final Path pomXmlPath;
        private final Document document;
        private final XPath xPath;
        private final String indentationString;

        public TransformationContext(Path pomXmlPath, Document document, String indentationString, XPath xPath) {
            this.pomXmlPath = pomXmlPath;
            this.document = document;
            this.indentationString = indentationString;
            this.xPath = xPath;
        }

        public Path getPomXmlPath() {
            return this.pomXmlPath;
        }

        public XPath getXPath() {
            return this.xPath;
        }

        public String getIndentationString() {
            return this.indentationString;
        }

        public Node indent(int indentCount) {
            StringBuilder sb = new StringBuilder(1 + indentCount * this.indentationString.length());
            sb.append('\n');
            for (int i = 0; i < indentCount; ++i) {
                sb.append(this.indentationString);
            }
            return this.document.createTextNode(sb.toString());
        }

        public Node textElement(String elementName, String value) {
            Element result = this.document.createElement(elementName);
            result.appendChild(this.document.createTextNode(value));
            return result;
        }
    }

    public static interface Transformation {
        public static Transformation addModule(String module) {
            return (document, context) -> {
                try {
                    Node ws;
                    Node modules = (Node)context.getXPath().evaluate(PomTransformer.anyNs("project", "modules"), document, XPathConstants.NODE);
                    if (modules == null) {
                        Node modulesIndent = context.indent(1);
                        modules = document.createElement("modules");
                        modules.appendChild(context.indent(1));
                        Node build = (Node)context.getXPath().evaluate(PomTransformer.anyNs("project", "build"), document, XPathConstants.NODE);
                        if (build != null) {
                            Node ws2 = build.getPreviousSibling();
                            if (ws2 == null || ws2.getNodeType() != 3) {
                                ws2 = context.indent(1);
                                build.getParentNode().insertBefore(ws2, build);
                            }
                            build.getParentNode().insertBefore(modulesIndent, ws2);
                            build.getParentNode().insertBefore(modules, ws2);
                        } else {
                            Node project = (Node)context.getXPath().evaluate(PomTransformer.anyNs("project"), document, XPathConstants.NODE);
                            if (project == null) {
                                throw new IllegalStateException(String.format("No <project> in file [%s]", context.getPomXmlPath()));
                            }
                            NodeList projectChildren = project.getChildNodes();
                            int len = projectChildren.getLength();
                            Node ws3 = null;
                            if (len == 0 || (ws3 = projectChildren.item(len - 1)).getNodeType() != 3) {
                                ws3 = document.createTextNode("\n");
                                project.appendChild(ws3);
                            }
                            project.insertBefore(modulesIndent, ws3);
                            project.insertBefore(modules, ws3);
                        }
                    }
                    Element moduleNode = document.createElement("module");
                    moduleNode.appendChild(document.createTextNode(module));
                    NodeList modulesChildren = modules.getChildNodes();
                    int len = modulesChildren.getLength();
                    if (len == 0 || (ws = modulesChildren.item(len - 1)).getNodeType() != 3) {
                        ws = context.indent(1);
                        modules.appendChild(ws);
                    }
                    modules.insertBefore(context.indent(2), ws);
                    modules.insertBefore(moduleNode, ws);
                }
                catch (XPathExpressionException | DOMException e) {
                    throw new RuntimeException(e);
                }
            };
        }

        public static Transformation addProperty(String name, String value) {
            return (document, context) -> {
                try {
                    Node ws;
                    Node props = (Node)context.getXPath().evaluate(PomTransformer.anyNs("project", "properties"), document, XPathConstants.NODE);
                    if (props == null) {
                        Node propsIndent = context.indent(1);
                        props = document.createElement("properties");
                        props.appendChild(context.indent(1));
                        Node project = (Node)context.getXPath().evaluate(PomTransformer.anyNs("project"), document, XPathConstants.NODE);
                        if (project == null) {
                            throw new IllegalStateException(String.format("No <project> in file [%s]", context.getPomXmlPath()));
                        }
                        Node refNode = (Node)context.getXPath().evaluate(PomTransformer.anyNs("project", "modules"), document, XPathConstants.NODE);
                        if (refNode != null) {
                            ws = refNode.getPreviousSibling();
                            if (ws == null || ws.getNodeType() != 3) {
                                ws = context.indent(1);
                                project.insertBefore(ws, refNode);
                            }
                        } else {
                            ws = project.getLastChild();
                            if (ws == null || ws.getNodeType() != 3) {
                                ws = context.indent(0);
                                project.appendChild(ws);
                            }
                        }
                        project.insertBefore(propsIndent, ws);
                        project.insertBefore(props, ws);
                    }
                    Element propNode = document.createElement(name);
                    propNode.appendChild(document.createTextNode(value));
                    NodeList modulesChildren = props.getChildNodes();
                    int len = modulesChildren.getLength();
                    if (len == 0 || (ws = modulesChildren.item(len - 1)).getNodeType() != 3) {
                        ws = context.indent(1);
                        props.appendChild(ws);
                    }
                    props.insertBefore(context.indent(2), ws);
                    props.insertBefore(propNode, ws);
                }
                catch (XPathExpressionException | DOMException e) {
                    throw new RuntimeException(e);
                }
            };
        }

        public static Transformation addDependencyManagementIfNeeded() {
            return (document, context) -> {
                try {
                    Node dependencyManagementDeps = (Node)context.getXPath().evaluate(PomTransformer.anyNs("project", "dependencyManagement", "dependencies"), document, XPathConstants.NODE);
                    if (dependencyManagementDeps == null) {
                        Node dependencyManagement = (Node)context.getXPath().evaluate(PomTransformer.anyNs("project", "dependencyManagement"), document, XPathConstants.NODE);
                        if (dependencyManagement == null) {
                            Node ws;
                            Node project = (Node)context.getXPath().evaluate(PomTransformer.anyNs("project"), document, XPathConstants.NODE);
                            if (project == null) {
                                throw new IllegalStateException(String.format("//project not found in [%s]", context.getPomXmlPath()));
                            }
                            Node refNode = (Node)context.getXPath().evaluate(PomTransformer.anyNs("project", "dependencies"), document, XPathConstants.NODE);
                            if (refNode == null) {
                                refNode = (Node)context.getXPath().evaluate(PomTransformer.anyNs("project", "build"), document, XPathConstants.NODE);
                            }
                            dependencyManagement = document.createElement("dependencyManagement");
                            if (refNode != null) {
                                ws = refNode.getPreviousSibling();
                                if (ws == null || ws.getNodeType() != 3) {
                                    ws = context.indent(1);
                                    project.insertBefore(ws, refNode);
                                }
                            } else {
                                ws = project.getLastChild();
                                if (ws == null || ws.getNodeType() != 3) {
                                    ws = context.indent(0);
                                    project.appendChild(ws);
                                }
                            }
                            project.insertBefore(dependencyManagement, ws);
                            project.insertBefore(context.indent(1), dependencyManagement);
                        }
                        dependencyManagementDeps = document.createElement("dependencies");
                        dependencyManagementDeps.appendChild(context.indent(2));
                        Node ws = dependencyManagement.getLastChild();
                        if (ws == null || ws.getNodeType() != 3) {
                            ws = context.indent(1);
                            dependencyManagement.appendChild(ws);
                        }
                        dependencyManagement.insertBefore(dependencyManagementDeps, ws);
                        dependencyManagement.insertBefore(context.indent(2), dependencyManagementDeps);
                    }
                }
                catch (XPathExpressionException | DOMException e) {
                    throw new RuntimeException(e);
                }
            };
        }

        public static Transformation addPluginManagementIfNeeded() {
            return (document, context) -> {
                try {
                    Node plugins = (Node)context.getXPath().evaluate(PomTransformer.anyNs("project", "build", "pluginManagement", "plugins"), document, XPathConstants.NODE);
                    if (plugins == null) {
                        Node pluginManagement;
                        Node ws;
                        Node build = (Node)context.getXPath().evaluate(PomTransformer.anyNs("project", "build"), document, XPathConstants.NODE);
                        if (build == null) {
                            Node project = (Node)context.getXPath().evaluate(PomTransformer.anyNs("project"), document, XPathConstants.NODE);
                            if (project == null) {
                                throw new IllegalStateException(String.format("//project not found in [%s]", context.getPomXmlPath()));
                            }
                            build = document.createElement("build");
                            ws = project.getLastChild();
                            if (ws == null || ws.getNodeType() != 3) {
                                ws = context.indent(0);
                                project.appendChild(ws);
                            }
                            project.insertBefore(build, ws);
                            project.insertBefore(context.indent(1), build);
                        }
                        if ((pluginManagement = (Node)context.getXPath().evaluate(PomTransformer.anyNs("project", "build", "pluginManagement"), document, XPathConstants.NODE)) == null) {
                            pluginManagement = document.createElement("pluginManagement");
                            ws = build.getLastChild();
                            if (ws == null || ws.getNodeType() != 3) {
                                ws = context.indent(1);
                                build.appendChild(ws);
                            }
                            build.insertBefore(pluginManagement, ws);
                            build.insertBefore(context.indent(2), pluginManagement);
                        }
                        plugins = document.createElement("plugins");
                        plugins.appendChild(context.indent(3));
                        ws = pluginManagement.getLastChild();
                        if (ws == null || ws.getNodeType() != 3) {
                            ws = context.indent(2);
                            pluginManagement.appendChild(ws);
                        }
                        pluginManagement.insertBefore(plugins, ws);
                        pluginManagement.insertBefore(context.indent(3), plugins);
                    }
                }
                catch (XPathExpressionException | DOMException e) {
                    throw new RuntimeException(e);
                }
            };
        }

        public static Transformation addManagedDependency(String groupId, String artifactId, String version) {
            return Transformation.addManagedDependency(new Gavtcs(groupId, artifactId, version, null, null, null));
        }

        public static Transformation addManagedDependency(Gavtcs gavtcs) {
            return (document, context) -> {
                try {
                    Transformation.addDependencyManagementIfNeeded().perform(document, context);
                    Node dependencyManagementDeps = (Node)context.getXPath().evaluate(PomTransformer.anyNs("project", "dependencyManagement", "dependencies"), document, XPathConstants.NODE);
                    NodeList dependencyManagementDepsChildren = dependencyManagementDeps.getChildNodes();
                    Node ws = null;
                    if (dependencyManagementDepsChildren.getLength() > 0) {
                        ws = dependencyManagementDepsChildren.item(dependencyManagementDepsChildren.getLength() - 1);
                    }
                    if (ws == null || ws.getNodeType() != 3) {
                        ws = context.indent(3);
                        dependencyManagementDeps.appendChild(ws);
                    }
                    dependencyManagementDeps.insertBefore(context.indent(3), ws);
                    Element dep = document.createElement("dependency");
                    dep.appendChild(context.indent(4));
                    dep.appendChild(context.textElement("groupId", gavtcs.groupId));
                    dep.appendChild(context.indent(4));
                    dep.appendChild(context.textElement("artifactId", gavtcs.artifactId));
                    dep.appendChild(context.indent(4));
                    dep.appendChild(context.textElement("version", gavtcs.version));
                    if (gavtcs.type != null) {
                        dep.appendChild(context.indent(4));
                        dep.appendChild(context.textElement("type", gavtcs.type));
                    }
                    if (gavtcs.classifier != null) {
                        dep.appendChild(context.indent(4));
                        dep.appendChild(context.textElement("classifier", gavtcs.classifier));
                    }
                    if (gavtcs.scope != null) {
                        dep.appendChild(context.indent(4));
                        dep.appendChild(context.textElement("scope", gavtcs.scope));
                    }
                    dep.appendChild(context.indent(3));
                    dependencyManagementDeps.insertBefore(dep, ws);
                }
                catch (XPathExpressionException | DOMException e) {
                    throw new RuntimeException(e);
                }
            };
        }

        public static Transformation addManagedPlugin(Plugin plugin) {
            return (document, context) -> {
                try {
                    Transformation.addPluginManagementIfNeeded().perform(document, context);
                    Node managedPlugins = (Node)context.getXPath().evaluate(PomTransformer.anyNs("project", "build", "pluginManagement", "plugins"), document, XPathConstants.NODE);
                    NodeList pluginsChildren = managedPlugins.getChildNodes();
                    Node ws = null;
                    if (pluginsChildren.getLength() > 0) {
                        ws = pluginsChildren.item(pluginsChildren.getLength() - 1);
                    }
                    if (ws == null || ws.getNodeType() != 3) {
                        ws = context.indent(4);
                        managedPlugins.appendChild(ws);
                    }
                    managedPlugins.insertBefore(context.indent(4), ws);
                    Element dep = document.createElement("plugin");
                    dep.appendChild(context.indent(5));
                    dep.appendChild(context.textElement("groupId", plugin.getGroupId()));
                    dep.appendChild(context.indent(5));
                    dep.appendChild(context.textElement("artifactId", plugin.getArtifactId()));
                    dep.appendChild(context.indent(5));
                    dep.appendChild(context.textElement("version", plugin.getVersion()));
                    dep.appendChild(context.indent(4));
                    managedPlugins.insertBefore(dep, ws);
                }
                catch (XPathExpressionException | DOMException e) {
                    throw new RuntimeException(e);
                }
            };
        }

        public void perform(Document var1, TransformationContext var2);
    }

    public static class Gavtcs {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String type;
        private final String classifier;
        private final String scope;

        public static Gavtcs importBom(String groupId, String artifactId, String version) {
            return new Gavtcs(groupId, artifactId, version, "pom", null, "import");
        }

        public static Gavtcs of(String rawGavtcs) {
            String[] gavtcArr = rawGavtcs.split(":");
            int i = 0;
            String groupId = gavtcArr[i++];
            String artifactId = gavtcArr[i++];
            String version = gavtcArr[i++];
            String type = i < gavtcArr.length ? Gavtcs.emptyToNull(gavtcArr[i++]) : null;
            String classifier = i < gavtcArr.length ? Gavtcs.emptyToNull(gavtcArr[i++]) : null;
            String scope = i < gavtcArr.length ? Gavtcs.emptyToNull(gavtcArr[i++]) : null;
            return new Gavtcs(groupId, artifactId, version, type, classifier, scope);
        }

        private static String emptyToNull(String string) {
            return string != null && !string.isEmpty() ? string : null;
        }

        public Gavtcs(String groupId, String artifactId, String version) {
            this(groupId, artifactId, version, null, null, null);
        }

        public Gavtcs(String groupId, String artifactId, String version, String type, String classifier, String scope) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.type = type;
            this.classifier = classifier;
            this.scope = scope;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getType() {
            return this.type;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getScope() {
            return this.scope;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder().append(this.groupId).append(':').append(this.artifactId).append(':').append(this.version);
            if (this.type != null || this.classifier != null || this.scope != null) {
                sb.append(':');
                if (this.type != null) {
                    sb.append(this.type);
                }
                if (this.classifier != null || this.scope != null) {
                    sb.append(':');
                    if (this.classifier != null) {
                        sb.append(this.classifier);
                    }
                    if (this.scope != null) {
                        sb.append(':').append(this.scope);
                    }
                }
            }
            return sb.toString();
        }
    }
}

