/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DnsDomainName
implements Serializable {
    private static final long serialVersionUID = -9123494137779222577L;
    private static final Logger LOG = LoggerFactory.getLogger(DnsDomainName.class);
    public static final DnsDomainName ROOT_DOMAIN;
    private final List<String> labels;
    private final String name;
    private final Short pointer;

    public static DnsDomainName newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new DnsDomainName(rawData, offset, length);
    }

    private DnsDomainName(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        int len;
        this.labels = new ArrayList<String>();
        Short foundPointer = null;
        boolean terminated = false;
        for (int cursor = 0; cursor < length; cursor += len) {
            len = rawData[offset + cursor] & 0xFF;
            int flag = len & 0xC0;
            if (flag == 0) {
                if (len == 0) {
                    terminated = true;
                    break;
                }
                if (length - ++cursor < len) {
                    StringBuilder sb = new StringBuilder(200);
                    sb.append("The data is too short to build a DnsDomainName. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length).append(", cursor: ").append(cursor);
                    throw new IllegalRawDataException(sb.toString());
                }
                this.labels.add(new String(rawData, offset + cursor, len));
                continue;
            }
            if (flag == 192) {
                if (length - cursor < 2) {
                    StringBuilder sb = new StringBuilder(200);
                    sb.append("The data is too short to build a DnsDomainName. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length).append(", cursor: ").append(cursor);
                    throw new IllegalRawDataException(sb.toString());
                }
                foundPointer = (short)(ByteArrays.getShort(rawData, offset + cursor) & 0x3FFF);
                terminated = true;
                break;
            }
            StringBuilder sb = new StringBuilder(200);
            sb.append("A label must start with 00 or 11. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.pointer = foundPointer;
        if (!terminated) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("No null termination nor pointer. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.name = this.joinLabels(this.labels);
    }

    private DnsDomainName(Builder builder2) {
        if (builder2 == null || builder2.labels == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder").append(builder2).append(" builder.labels: ").append(builder2.labels);
            throw new NullPointerException(sb.toString());
        }
        for (String label : builder2.labels) {
            if (label.getBytes().length <= 63) continue;
            throw new IllegalArgumentException("Length of a label must be less than 64. label: " + label);
        }
        if (builder2.pointer != null && (builder2.pointer & 0xC000) != 0) {
            throw new IllegalArgumentException("(builder.pointer & 0xC000) must be zero. builder.pointer: " + builder2.pointer);
        }
        this.labels = new ArrayList<String>(builder2.labels);
        this.name = this.joinLabels(this.labels);
        this.pointer = builder2.pointer;
    }

    private String joinLabels(List<String> lbls) {
        if (lbls.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = lbls.iterator();
        while (true) {
            sb.append(iter.next());
            if (!iter.hasNext()) break;
            sb.append(".");
        }
        return sb.toString();
    }

    public List<String> getLabels() {
        return new ArrayList<String>(this.labels);
    }

    public String getName() {
        return this.name;
    }

    public Short getPointer() {
        return this.pointer;
    }

    public Integer getPointerAsInt() {
        if (this.pointer != null) {
            return (int)this.pointer;
        }
        return null;
    }

    public String decompress(byte[] headerRawData) throws IllegalRawDataException {
        if (headerRawData == null) {
            throw new NullPointerException("headerRawData is null.");
        }
        return this.decompress(headerRawData, new ArrayList<Short>());
    }

    private String decompress(byte[] headerRawData, List<Short> pointers) throws IllegalRawDataException {
        if (this.pointer == null) {
            return this.name;
        }
        if (pointers.contains(this.pointer)) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("Circular reference detected. data: ").append(ByteArrays.toHexString(headerRawData, " ")).append(", offset: ").append(this.pointer).append(", name: ").append(this.name);
            throw new IllegalRawDataException(sb.toString());
        }
        pointers.add(this.pointer);
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(".").append(new DnsDomainName(headerRawData, this.pointer.shortValue(), headerRawData.length - this.pointer).decompress(headerRawData, pointers));
        return sb.toString();
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public byte[] getRawData() {
        byte[] data = new byte[this.length()];
        int cursor = 0;
        for (String label : this.labels) {
            byte[] labelBytes = label.getBytes();
            data[cursor] = (byte)labelBytes.length;
            System.arraycopy(labelBytes, 0, data, ++cursor, labelBytes.length);
            cursor += labelBytes.length;
        }
        if (this.pointer != null) {
            byte[] offsetBytes = ByteArrays.toByteArray(this.pointer);
            offsetBytes[0] = (byte)(offsetBytes[0] | 0xC0);
            System.arraycopy(offsetBytes, 0, data, cursor, offsetBytes.length);
        }
        return data;
    }

    public int length() {
        int len = 0;
        for (String label : this.labels) {
            len += label.length() + 1;
        }
        len = this.pointer != null ? (len += 2) : ++len;
        return len;
    }

    public String toString() {
        if (this.labels.size() == 0 && this.pointer == null) {
            return "<ROOT>";
        }
        if (this.pointer == null) {
            return this.name;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[name: ").append(this.name).append(", pointer: ").append(this.pointer).append("]");
        return sb.toString();
    }

    public String toString(byte[] headerRawData) {
        String decompressedName;
        if (this.labels.size() == 0 && this.pointer == null) {
            return "<ROOT>";
        }
        if (this.pointer == null) {
            return this.name;
        }
        try {
            decompressedName = this.decompress(headerRawData);
        }
        catch (IllegalRawDataException e) {
            LOG.error("Error occurred during building complete name.", e);
            decompressedName = "Error occurred during building complete name";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(decompressedName).append(" (name: ").append(this.name).append(", pointer: ").append(this.pointer).append(")");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.pointer == null ? 0 : this.pointer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DnsDomainName other = (DnsDomainName)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        return !(this.pointer == null ? other.pointer != null : !this.pointer.equals(other.pointer));
    }

    static {
        try {
            ROOT_DOMAIN = new DnsDomainName(new byte[]{0}, 0, 1);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)"Never get here.");
        }
    }

    public static final class Builder {
        private List<String> labels;
        private Short pointer = null;

        public Builder() {
        }

        private Builder(DnsDomainName obj) {
            this.labels = obj.labels;
            this.pointer = obj.pointer;
        }

        public Builder labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder labels(String[] labels) {
            this.labels = Arrays.asList(labels);
            return this;
        }

        public Builder pointer(Short pointer) {
            this.pointer = pointer;
            return this;
        }

        public DnsDomainName build() {
            return new DnsDomainName(this);
        }
    }
}

