/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv.ui.preview;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormats;
import com.intellij.database.csv.CsvFormatter;
import com.intellij.database.csv.ui.preview.CsvFormatPreview;
import com.intellij.database.csv.ui.preview.TextView;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class TableAndTextCsvFormatPreview
implements CsvFormatPreview,
Disposable {
    private static final String[] DUMMY_HEADER = new String[]{"customer_id", "first_name", "last_name", "active", "create_date"};
    private static final String[][] DUMMY_DATA = new String[][]{{"1", "MARY", "SMITH", "true", "2006-02-14"}, {"2", "PATRICIA", "JOHNSON", "true", "2006-02-14"}, {"3", "LINDA", "WILLIAMS", "true", "2006-02-14"}, {"4", "BARBARA", "JONES", "false", "2006-02-14"}, {"5", "ELIZABETH", "BROWN", "false", "2006-02-14"}, {"6", "JENNIFER", "DAVIS", "true", "2006-02-14"}, {"7", "MARIA", "MILLER", "false", "2006-02-14"}, {"8", "SUSAN", "WILSON", "true", "2006-02-14"}, {"9", "MARGARET", "MOORE", "true", "2006-02-14"}, {"10", "DOROTHY", "TAYLOR", "true", "2006-02-14"}, {"11", "LISA", "ANDERSON", "true", "2006-02-14"}, {"12", "NANCY", "THOMAS", "true", "2006-02-14"}, {"13", "KAREN", "JACKSON", "false", "2006-02-14"}, {"14", "BETTY", "WHITE", "true", "2006-02-14"}, {"15", "HELEN", "HARRIS", "true", "2006-02-14"}, {"16", "SANDRA", "MARTIN", "true", "2006-02-14"}, {"17", "DONNA", "THOMPSON", "true", "2006-02-14"}, {"18", "CAROL", "GARCIA", "true", "2006-02-14"}, {"19", "RUTH", "MARTINEZ", "false", "2006-02-14"}, {"20", "SHARON", "ROBINSON", "false", "2006-02-14"}};
    private final JPanel myPanel;
    private final CsvDocumentDataHookUp myHookUp;
    private final TextView myTextView;

    public TableAndTextCsvFormatPreview(@NotNull Project project, @NotNull Disposable parent) {
        if (project == null) {
            TableAndTextCsvFormatPreview.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            TableAndTextCsvFormatPreview.$$$reportNull$$$0(1);
        }
        Disposer.register((Disposable)parent, (Disposable)this);
        Document document = EditorFactory.getInstance().createDocument((CharSequence)"");
        this.myHookUp = new CsvDocumentDataHookUp(project, (CsvFormat)CsvFormats.TSV_FORMAT.getValue(), document, null);
        Disposer.register((Disposable)this, (Disposable)this.myHookUp);
        DataGrid grid = GridUtil.createCsvPreviewDataGrid(project, (DocumentDataHookUp)this.myHookUp);
        Disposer.register((Disposable)this, (Disposable)grid);
        this.myTextView = new TextView(document, this);
        this.myPanel = new JPanel(new GridLayout(2, 1, 0, 8));
        this.myPanel.add(this.myTextView.getComponent());
        this.myPanel.add((Component)grid.getPanel().getComponent());
    }

    @Override
    public void setFormat(@NotNull CsvFormat format, @NotNull GridRequestSource source) {
        if (format == null) {
            TableAndTextCsvFormatPreview.$$$reportNull$$$0(2);
        }
        if (source == null) {
            TableAndTextCsvFormatPreview.$$$reportNull$$$0(3);
        }
        this.myTextView.setText("");
        this.myHookUp.setFormat(format, source);
        this.myTextView.setText(TableAndTextCsvFormatPreview.formatData(this.myHookUp.getFormat()));
    }

    @NotNull
    public static String formatData(@NotNull CsvFormat format) {
        if (format == null) {
            TableAndTextCsvFormatPreview.$$$reportNull$$$0(4);
        }
        CsvFormatter formatter = new CsvFormatter(format);
        StringBuilder sb = new StringBuilder();
        sb.append(formatter.formatHeader(Arrays.asList(DUMMY_HEADER))).append(formatter.recordSeparator());
        for (String[] row : DUMMY_DATA) {
            sb.append(formatter.formatRecord(Arrays.asList(row))).append(formatter.recordSeparator());
        }
        String string = sb.toString();
        if (string == null) {
            TableAndTextCsvFormatPreview.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            TableAndTextCsvFormatPreview.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/csv/ui/preview/TableAndTextCsvFormatPreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/csv/ui/preview/TableAndTextCsvFormatPreview";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "formatData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setFormat";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "formatData";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

