/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.render.displaylist;

import com.openhtmltopdf.render.displaylist.DisplayListOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class DisplayListContainer {
    public abstract DisplayListPageContainer getPageInstructions(int var1);

    public abstract int getMinPage();

    public abstract int getMaxPage();

    public static class DisplayListPageContainer {
        private List<DisplayListOperation> ops = null;
        private List<DisplayListPageContainer> shadowPages = null;
        private final DisplayListPageContainer basePage;

        public DisplayListPageContainer(DisplayListPageContainer basePage) {
            this.basePage = basePage;
        }

        public boolean isShadowPage() {
            return this.basePage != null;
        }

        private DisplayListPageContainer getBasePage() {
            return this.basePage;
        }

        public void addOp(DisplayListOperation dlo) {
            if (this.ops == null) {
                this.ops = new ArrayList<DisplayListOperation>();
            }
            this.ops.add(dlo);
        }

        private void addShadowsUntil(int shadow) {
            for (int i = this.shadowPages.size(); i <= shadow; ++i) {
                this.shadowPages.add(new DisplayListPageContainer(this));
            }
        }

        public DisplayListPageContainer getShadowPage(int shadowNumber) {
            if (this.isShadowPage()) {
                return this.getBasePage().getShadowPage(shadowNumber);
            }
            if (this.shadowPages == null) {
                this.shadowPages = new ArrayList<DisplayListPageContainer>();
            }
            this.addShadowsUntil(shadowNumber);
            return this.shadowPages.get(shadowNumber);
        }

        public List<DisplayListPageContainer> shadowPages() {
            if (this.isShadowPage()) {
                return this.basePage.shadowPages();
            }
            return this.shadowPages == null ? Collections.emptyList() : this.shadowPages;
        }

        public List<DisplayListOperation> getOperations() {
            return this.ops == null ? Collections.emptyList() : this.ops;
        }
    }
}

