/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtFakeLightMethod;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0087\u0010\u001a\u0014\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007\u00a8\u0006\n"}, d2={"collectContainingClasses", "", "Lcom/intellij/psi/PsiClass;", "methods", "", "Lcom/intellij/psi/PsiMethod;", "getPsiClass", "element", "Lcom/intellij/psi/PsiElement;", "getPsiMethod", "kotlin.highlighting.k1"})
public final class JavaPsiUtilsKt {
    @NotNull
    public static final Set<PsiClass> collectContainingClasses(@NotNull Collection<? extends PsiMethod> methods) {
        Intrinsics.checkNotNullParameter(methods, (String)"methods");
        HashSet<PsiClass> classes = new HashSet<PsiClass>();
        for (PsiMethod psiMethod : methods) {
            ProgressManager.checkCanceled();
            PsiClass parentClass = psiMethod.getContainingClass();
            if (parentClass == null || Intrinsics.areEqual((Object)"java.lang.Object", (Object)parentClass.getQualifiedName())) continue;
            classes.add(parentClass);
        }
        return classes;
    }

    @ApiStatus.Internal
    @Nullable
    public static final PsiClass getPsiClass(@Nullable PsiElement element) {
        PsiClass psiClass;
        block5: {
            while (true) {
                if (element == null) {
                    psiClass = null;
                    break block5;
                }
                if (element instanceof PsiClass) {
                    psiClass = (PsiClass)element;
                    break block5;
                }
                if (element instanceof KtClass) {
                    KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)element));
                    if (ktLightClass == null) {
                        ktLightClass = (KtLightClass)LightClassUtilsKt.toFakeLightClass((KtClassOrObject)((KtClassOrObject)element));
                    }
                    psiClass = (PsiClass)ktLightClass;
                    break block5;
                }
                if (!(element.getParent() instanceof KtClass)) break;
                element = element.getParent();
            }
            psiClass = null;
        }
        return psiClass;
    }

    @ApiStatus.Internal
    @Nullable
    public static final PsiMethod getPsiMethod(@Nullable PsiElement element) {
        PsiMethod psiMethod;
        PsiElement psiElement = element;
        PsiElement parent2 = psiElement != null ? psiElement.getParent() : null;
        if (element == null) {
            psiMethod = null;
        } else if (element instanceof PsiMethod) {
            psiMethod = (PsiMethod)element;
        } else if (parent2 instanceof KtNamedFunction || parent2 instanceof KtSecondaryConstructor) {
            psiMethod = LightClassUtil.INSTANCE.getLightClassMethod((KtFunction)parent2);
            if (psiMethod == null) {
                psiMethod = (PsiMethod)KtFakeLightMethod.Companion.get((KtNamedDeclaration)parent2);
            }
        } else {
            psiMethod = null;
        }
        return psiMethod;
    }
}

