/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import org.jline.terminal.Terminal;
import org.jline.utils.Colors;
import org.jline.utils.InfoCmp;
import org.jline.utils.NonBlockingReader;

public class ColorPalette {
    public static final ColorPalette DEFAULT = new ColorPalette();
    private final Terminal terminal;
    private String distanceName;
    private Colors.Distance distance;
    private boolean osc4;
    private int[] palette;

    public ColorPalette() {
        this.terminal = null;
        this.distanceName = null;
        this.palette = Colors.DEFAULT_COLORS_256;
    }

    public ColorPalette(Terminal terminal) throws IOException {
        this(terminal, null);
    }

    public ColorPalette(Terminal terminal, String distance) throws IOException {
        this.terminal = terminal;
        this.distanceName = distance;
        this.loadPalette(false);
    }

    protected void loadPalette(boolean doLoad) throws IOException {
        if (this.terminal != null) {
            int[] pal;
            int[] nArray = pal = doLoad ? ColorPalette.doLoad(this.terminal) : null;
            if (pal != null) {
                this.palette = pal;
                this.osc4 = true;
            } else {
                Integer cols = this.terminal.getNumericCapability(InfoCmp.Capability.max_colors);
                this.palette = cols != null ? (cols == Colors.DEFAULT_COLORS_88.length ? Colors.DEFAULT_COLORS_88 : Arrays.copyOf(Colors.DEFAULT_COLORS_256, Math.min(cols, 256))) : Arrays.copyOf(Colors.DEFAULT_COLORS_256, 256);
                this.osc4 = false;
            }
        } else {
            this.palette = Colors.DEFAULT_COLORS_256;
            this.osc4 = false;
        }
    }

    public int getLength() {
        return this.palette.length;
    }

    public int getColor(int index) {
        return this.palette[index];
    }

    public int round(int r2, int g2, int b2) {
        return Colors.roundColor((r2 << 16) + (g2 << 8) + b2, this.palette, this.palette.length, this.getDist());
    }

    public int round(int col) {
        if (col >= this.palette.length) {
            col = Colors.roundColor(DEFAULT.getColor(col), this.palette, this.palette.length, this.getDist());
        }
        return col;
    }

    protected Colors.Distance getDist() {
        if (this.distance == null) {
            this.distance = Colors.getDistance(this.distanceName);
        }
        return this.distance;
    }

    private static int[] doLoad(Terminal terminal) throws IOException {
        PrintWriter writer = terminal.writer();
        NonBlockingReader reader = terminal.reader();
        int[] palette = new int[256];
        for (int i2 = 0; i2 < 16; ++i2) {
            StringBuilder req = new StringBuilder(1024);
            req.append("\u001b]4");
            for (int j2 = 0; j2 < 16; ++j2) {
                req.append(';').append(i2 * 16 + j2).append(";?");
            }
            req.append("\u001b\\");
            writer.write(req.toString());
            writer.flush();
            boolean black = true;
            for (int j3 = 0; j3 < 16 && reader.peek(50L) >= 0; ++j3) {
                int c2;
                if (reader.read(10L) != 27 || reader.read(10L) != 93 || reader.read(10L) != 52 || reader.read(10L) != 59) {
                    return null;
                }
                int idx = 0;
                while ((c2 = reader.read(10L)) >= 48 && c2 <= 57) {
                    idx = idx * 10 + (c2 - 48);
                }
                if (c2 != 59) {
                    return null;
                }
                if (idx > 255) {
                    return null;
                }
                if (reader.read(10L) != 114 || reader.read(10L) != 103 || reader.read(10L) != 98 || reader.read(10L) != 58) {
                    return null;
                }
                StringBuilder sb = new StringBuilder(16);
                ArrayList<String> rgb = new ArrayList<String>();
                while (true) {
                    if ((c2 = reader.read(10L)) == 7) {
                        rgb.add(sb.toString());
                        break;
                    }
                    if (c2 == 27) {
                        c2 = reader.read(10L);
                        if (c2 == 92) {
                            rgb.add(sb.toString());
                            break;
                        }
                        return null;
                    }
                    if (c2 >= 48 && c2 <= 57 || c2 >= 65 && c2 <= 90 || c2 >= 97 && c2 <= 122) {
                        sb.append((char)c2);
                        continue;
                    }
                    if (c2 != 47) continue;
                    rgb.add(sb.toString());
                    sb.setLength(0);
                }
                if (rgb.size() != 3) {
                    return null;
                }
                double r2 = (double)Integer.parseInt((String)rgb.get(0), 16) / ((double)(1 << 4 * ((String)rgb.get(0)).length()) - 1.0);
                double g2 = (double)Integer.parseInt((String)rgb.get(1), 16) / ((double)(1 << 4 * ((String)rgb.get(1)).length()) - 1.0);
                double b2 = (double)Integer.parseInt((String)rgb.get(2), 16) / ((double)(1 << 4 * ((String)rgb.get(2)).length()) - 1.0);
                palette[idx] = (int)((Math.round(r2 * 255.0) << 16) + (Math.round(g2 * 255.0) << 8) + Math.round(b2 * 255.0));
                black &= palette[idx] == 0;
            }
            if (black) break;
        }
        int max = 256;
        while (max > 0 && palette[--max] == 0) {
        }
        return Arrays.copyOfRange(palette, 0, max + 1);
    }

    public String toString() {
        return "ColorPalette[length=" + this.getLength() + ", distance='" + this.getDist() + "']";
    }
}

