/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jline.builtins.ConsoleOptionGetter;

public class Styles {
    protected static final List<String> ANSI_STYLES = Arrays.asList("blink", "bold", "conceal", "crossed-out", "crossedout", "faint", "hidden", "inverse", "inverse-neg", "inverseneg", "italic", "underline");
    private static final Pattern STYLE_ELEMENT_SEPARATOR = Pattern.compile(":");
    private static final Pattern STYLE_ELEMENT_PATTERN = Pattern.compile("([a-z]{2}|\\*\\.[a-zA-Z0-9]+)=(([!~#]?[a-zA-Z0-9]+[a-z0-9-;]*)?|[A-Z_]+)(,(([!~#]?[a-zA-Z0-9]+[a-z0-9-;]*)?|[A-Z_]+))*");

    private static ConsoleOptionGetter optionGetter() {
        try {
            return (ConsoleOptionGetter)Class.forName("org.jline.console.SystemRegistry").getDeclaredMethod("get", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static <T> T consoleOption(String name2, T defVal) {
        T out = defVal;
        ConsoleOptionGetter cog = Styles.optionGetter();
        if (cog != null) {
            out = cog.consoleOption(name2, defVal);
        }
        return out;
    }

    public static class StyleCompiler {
        private static final List<String> COLORS_8 = Arrays.asList("white", "black", "red", "blue", "green", "yellow", "magenta", "cyan");
        private static final Map<String, Integer> COLORS_NANO = new HashMap<String, Integer>();
        private final Map<String, String> colors;
        private final Map<String, String> tokenColors;
        private final boolean nanoStyle;

        public StyleCompiler(Map<String, String> colors, boolean nanoStyle) {
            this.colors = colors;
            this.nanoStyle = nanoStyle;
            this.tokenColors = (Map)Styles.consoleOption("NANORC_THEME", new HashMap());
        }

        public String getStyle(String reference2) {
            String rawStyle = this.colors.get(reference2);
            if (rawStyle == null) {
                return null;
            }
            if (rawStyle.matches("[A-Z_]+")) {
                rawStyle = this.tokenColors.getOrDefault(rawStyle, "normal");
            } else if (!this.nanoStyle && rawStyle.matches("[0-9]*(;[0-9]+){0,2}")) {
                return rawStyle;
            }
            StringBuilder out = new StringBuilder();
            boolean first = true;
            boolean fg = true;
            for (String s2 : rawStyle.split(",")) {
                if (s2.trim().isEmpty()) {
                    fg = false;
                    continue;
                }
                if (!first) {
                    out.append(",");
                }
                if (ANSI_STYLES.contains(s2)) {
                    out.append(s2);
                } else if (COLORS_8.contains(s2) || COLORS_NANO.containsKey(s2) || s2.startsWith("light") || s2.startsWith("bright") || s2.startsWith("~") || s2.startsWith("!") || s2.matches("\\d+") || s2.matches("[#x][0-9a-fA-F]{6}") || s2.equals("normal") || s2.equals("default")) {
                    if (s2.matches("[#x][0-9a-fA-F]{6}")) {
                        if (fg) {
                            out.append("fg-rgb:");
                        } else {
                            out.append("bg-rgb:");
                        }
                        out.append(s2);
                    } else if (s2.matches("\\d+") || COLORS_NANO.containsKey(s2)) {
                        if (fg) {
                            out.append("38;5;");
                        } else {
                            out.append("48;5;");
                        }
                        out.append(s2.matches("\\d+") ? s2 : COLORS_NANO.get(s2).toString());
                    } else {
                        if (fg) {
                            out.append("fg:");
                        } else {
                            out.append("bg:");
                        }
                        if (COLORS_8.contains(s2) || s2.startsWith("~") || s2.startsWith("!") || s2.startsWith("bright-")) {
                            out.append(s2);
                        } else if (s2.startsWith("light")) {
                            out.append("!").append(s2.substring(5));
                        } else if (s2.startsWith("bright")) {
                            out.append("!").append(s2.substring(6));
                        } else {
                            out.append("default");
                        }
                    }
                    fg = false;
                }
                first = false;
            }
            return out.toString();
        }

        static {
            COLORS_NANO.put("pink", 204);
            COLORS_NANO.put("purple", 163);
            COLORS_NANO.put("mauve", 134);
            COLORS_NANO.put("lagoon", 38);
            COLORS_NANO.put("mint", 48);
            COLORS_NANO.put("lime", 148);
            COLORS_NANO.put("peach", 215);
            COLORS_NANO.put("orange", 208);
            COLORS_NANO.put("latte", 137);
        }
    }
}

