/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.factories;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiField;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.impl.PsiFieldStubImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.LightStubElementFactory;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFieldStubFactory
implements LightStubElementFactory<PsiFieldStubImpl, PsiField> {
    private static final int INITIALIZER_LENGTH_LIMIT = 1000;

    @NotNull
    public PsiFieldStubImpl createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement<?> parentStub) {
        if (tree == null) {
            JavaFieldStubFactory.$$$reportNull$$$0(0);
        }
        if (node == null) {
            JavaFieldStubFactory.$$$reportNull$$$0(1);
        }
        if (parentStub == null) {
            JavaFieldStubFactory.$$$reportNull$$$0(2);
        }
        TypeInfo typeInfo = TypeInfo.create(tree, node, parentStub);
        boolean isDeprecatedByComment = false;
        boolean hasDeprecatedAnnotation = false;
        boolean hasDocComment = false;
        String name = null;
        String initializer = null;
        boolean expectingInit = false;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type = child.getTokenType();
            if (type == JavaDocElementType.DOC_COMMENT) {
                hasDocComment = true;
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment(tree, child);
                continue;
            }
            if (type == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation(tree, child);
                continue;
            }
            if (type == JavaTokenType.IDENTIFIER) {
                name = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (type == JavaTokenType.EQ) {
                expectingInit = true;
                continue;
            }
            if (!expectingInit || ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(type) || type == JavaTokenType.SEMICOLON) continue;
            initializer = JavaFieldStubFactory.encodeInitializer(tree, child);
            break;
        }
        boolean isEnumConst = node.getTokenType() == JavaElementType.ENUM_CONSTANT;
        byte flags = PsiFieldStubImpl.packFlags(isEnumConst, isDeprecatedByComment, hasDeprecatedAnnotation, hasDocComment);
        return new PsiFieldStubImpl(parentStub, name, typeInfo, initializer, flags);
    }

    public PsiField createPsi(@NotNull PsiFieldStubImpl stub) {
        if (stub == null) {
            JavaFieldStubFactory.$$$reportNull$$$0(3);
        }
        return JavaStubElementType.getFileStub(stub).getPsiFactory().createField(stub);
    }

    @NotNull
    public PsiFieldStubImpl createStub(@NotNull PsiField psi, @Nullable StubElement parentStub) {
        if (psi == null) {
            JavaFieldStubFactory.$$$reportNull$$$0(4);
        }
        String message = "Should not be called. Element=" + psi + "; class" + psi.getClass() + "; file=" + (psi.isValid() ? psi.getContainingFile() : "-");
        throw new UnsupportedOperationException(message);
    }

    private static String encodeInitializer(LighterAST tree, LighterASTNode initializer) {
        IElementType type = initializer.getTokenType();
        if (type == JavaElementType.NEW_EXPRESSION || type == JavaElementType.METHOD_CALL_EXPRESSION) {
            return ";INITIALIZER_NOT_STORED;";
        }
        if (initializer.getEndOffset() - initializer.getStartOffset() > 1000) {
            return ";INITIALIZER_TOO_LONG;";
        }
        return LightTreeUtil.toFilteredString((LighterAST)tree, (LighterASTNode)initializer, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/java/stubs/factories/JavaFieldStubFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createPsi";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

